/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net.proxy;

import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jp.go.nict.langrid.commons.net.proxy.pac.PacProxySelector;

public class SpecificProxySelector
extends PacProxySelector {
    private String httpProxyHost;
    private int httpProxyPort;
    private String httpsProxyHost;
    private int httpsProxyPort;
    private String ignoreList;
    private boolean proxyEqualy = false;
    private static final String JS_TEMPLATE = "function FindProxyForURL(url, host) '{'\n  if ( {4} ) '{'\n    return ''DIRECT'';\n  } else '{'\n    if(url.toLowerCase().indexOf(''https'') == 0) '{'\n      return ''PROXY {2}:{3}; DIRECT'';\n    } else '{'\n      return ''PROXY {0}:{1}; DIRECT'';\n    }\n  }\n}\n";
    private static final String IPADDRESS_CONDITION_TEMPLATE = "isInNet(host, ''{0}'', ''{1}'')";
    private static final String HOST_CONDITION_TEMPLATE = "shExpMatch(host, ''{0}'')";

    public SpecificProxySelector(String httpProxyHost, int httpProxyPort, String ignoreList) throws ParseException {
        this(httpProxyHost, httpProxyPort, httpProxyHost, httpProxyPort, ignoreList);
        this.proxyEqualy = true;
    }

    public SpecificProxySelector(String httpProxyHost, int httpProxyPort, String httpsProxyHost, int httpsProxyPort, String ignoreList) throws ParseException {
        super(SpecificProxySelector.makePacScript(httpProxyHost, httpProxyPort, httpsProxyHost, httpsProxyPort, ignoreList));
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
        this.httpsProxyHost = httpsProxyHost;
        this.httpsProxyPort = httpsProxyPort;
        this.ignoreList = ignoreList;
        this.proxyEqualy = false;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public int getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public String getHttpsProxyHost() {
        return this.httpsProxyHost;
    }

    public int getHttpsProxyPort() {
        return this.httpsProxyPort;
    }

    public String getIgnoreList() {
        return this.ignoreList;
    }

    public boolean isProxyEqualy() {
        return this.proxyEqualy;
    }

    static String makePacScript(String httpProxyHost, int httpProxyPort, String httpsProxyHost, int httpsProxyPort, String ignoreList) throws ParseException {
        String[] ignorePatterns = SpecificProxySelector.sparateIgnoreList(ignoreList);
        String ignoreCondition = SpecificProxySelector.makeIgnoreCondition(ignorePatterns);
        return MessageFormat.format(JS_TEMPLATE, httpProxyHost, "" + httpProxyPort, httpsProxyHost, "" + httpsProxyPort, ignoreCondition);
    }

    private static String makeIgnoreCondition(String[] ignorePatterns) throws ParseException {
        if (ignorePatterns.length == 0) {
            return "false";
        }
        StringBuilder builder = new StringBuilder();
        String delimiter = "";
        for (String ignorePattern : ignorePatterns) {
            String condition = SpecificProxySelector.isIPAddress(ignorePattern = ignorePattern.trim()) ? SpecificProxySelector.makeIPAddressCondition(ignorePattern) : SpecificProxySelector.makeHostCondition(ignorePattern);
            builder.append(delimiter);
            builder.append(condition);
            delimiter = " || ";
        }
        return builder.toString();
    }

    private static String makeHostCondition(String ignorePattern) {
        return MessageFormat.format(HOST_CONDITION_TEMPLATE, ignorePattern);
    }

    static String makeIPAddressCondition(String ignorePattern) {
        StringTokenizer tokenizer = new StringTokenizer(ignorePattern, ".");
        int tokenCount = tokenizer.countTokens();
        StringBuilder ip = new StringBuilder();
        StringBuilder netmask = new StringBuilder();
        String delimiter = "";
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int num = SpecificProxySelector.translateIPAddressNumber(token);
            ip.append(delimiter);
            ip.append(num);
            netmask.append(delimiter);
            netmask.append(SpecificProxySelector.isWildcard(token) ? "0" : "255");
            delimiter = ".";
        }
        for (int i = tokenCount; i < 4; ++i) {
            ip.append(delimiter);
            ip.append("0");
            netmask.append(delimiter);
            netmask.append("0");
            delimiter = ".";
        }
        return MessageFormat.format(IPADDRESS_CONDITION_TEMPLATE, ip.toString(), netmask.toString());
    }

    static boolean isIPAddress(String ignorePattern) throws ParseException {
        StringTokenizer tokenizer = new StringTokenizer(ignorePattern, ".");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount > 4) {
            return false;
        }
        boolean wildcard = false;
        boolean wildcardAfterAddress = false;
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (SpecificProxySelector.translateIPAddressNumber(token) == -1) {
                return false;
            }
            if (SpecificProxySelector.isWildcard(token)) {
                wildcard = true;
                continue;
            }
            if (!wildcard) continue;
            wildcardAfterAddress = true;
        }
        if (wildcardAfterAddress) {
            throw new ParseException("", 0);
        }
        if (!wildcard && tokenCount < 4) {
            throw new ParseException("", 0);
        }
        return true;
    }

    static boolean isWildcard(String token) {
        return "*".equals(token);
    }

    static int translateIPAddressNumber(String token) {
        try {
            if (SpecificProxySelector.isWildcard(token)) {
                return 0;
            }
            int num = Integer.parseInt(token);
            if (0 <= num && num <= 255) {
                return num;
            }
            return -1;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    private static String[] sparateIgnoreList(String ignoreList) throws ParseException {
        if (ignoreList == null || ignoreList.trim().equals("")) {
            return new String[0];
        }
        if (ignoreList.indexOf("'") != -1 || ignoreList.indexOf("\"") != -1) {
            throw new ParseException("", 0);
        }
        ArrayList<String> ret = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(ignoreList, ",; \n");
        while (tokenizer.hasMoreTokens()) {
            ret.add(tokenizer.nextToken());
        }
        return ret.toArray(new String[ret.size()]);
    }
}

