/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net.proxy.pac;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.net.DNSUtil;
import jp.go.nict.langrid.commons.net.URLUtil;
import jp.go.nict.langrid.commons.net.proxy.ProxyUtil;
import jp.go.nict.langrid.commons.net.proxy.pac.PacEngine;
import jp.go.nict.langrid.commons.net.proxy.pac.ProxyFormatException;

public class PacProxySelector
extends ProxySelector {
    private volatile PacEngine engine;
    private Thread pacLoadingThread;
    private static Logger logger = Logger.getLogger(PacProxySelector.class.getName());

    public PacProxySelector(String pacScript) {
        this.engine = new PacEngine(pacScript);
    }

    public PacProxySelector(final URL pacScriptUrl) {
        this.pacLoadingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                String script = null;
                try {
                    script = this.getScript(pacScriptUrl);
                }
                catch (UnknownHostException e) {
                    String host = pacScriptUrl.getHost();
                    for (String s : DNSUtil.listSuffixes()) {
                        try {
                            script = this.getScript(URLUtil.replaceHost(pacScriptUrl, host + "." + s));
                        }
                        catch (MalformedURLException malformedURLException) {
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                }
                if (script != null) {
                    PacProxySelector.this.engine = new PacEngine(script);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String getScript(URL url) throws UnknownHostException {
                block8: {
                    String string;
                    HttpURLConnection con = (HttpURLConnection)url.openConnection(Proxy.NO_PROXY);
                    con.setConnectTimeout(3000);
                    con.setReadTimeout(3000);
                    InputStream is = con.getInputStream();
                    try {
                        string = StreamUtil.readAsString(is, "UTF-8");
                    }
                    catch (Throwable throwable) {
                        try {
                            is.close();
                            con.disconnect();
                            throw throwable;
                        }
                        catch (UnknownHostException e) {
                            throw e;
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new RuntimeException(e);
                        }
                        catch (SocketTimeoutException e) {
                            break block8;
                        }
                        catch (IOException e) {
                            logger.log(Level.WARNING, "failed to read pac script.", e);
                        }
                    }
                    is.close();
                    con.disconnect();
                    return string;
                }
                return null;
            }
        });
        this.pacLoadingThread.start();
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
    }

    @Override
    public List<Proxy> select(URI uri) {
        try {
            PacEngine engine = this.getEngine();
            if (engine == null) {
                return ProxyUtil.DIRECT;
            }
            return engine.findProxyForUri(uri);
        }
        catch (ProxyFormatException e) {
            logger.log(Level.WARNING, "proxy format error occurred", e);
            return ProxyUtil.DIRECT;
        }
        catch (UnknownHostException e) {
            logger.log(Level.WARNING, "invalid host name: " + uri, e);
            return ProxyUtil.DIRECT;
        }
    }

    protected PacEngine getEngine() {
        Thread t = this.pacLoadingThread;
        if (t == null) {
            return this.engine;
        }
        try {
            t.join(5000L);
            this.pacLoadingThread = null;
            return this.engine;
        }
        catch (InterruptedException e) {
            return this.engine;
        }
    }
}

