/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.parameter;

import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.go.nict.langrid.commons.parameter.ParameterLoader;
import jp.go.nict.langrid.commons.parameter.ParameterRequiredException;
import jp.go.nict.langrid.commons.transformer.PassthroughTransformer;
import jp.go.nict.langrid.commons.transformer.StringSplittingTransformer;
import jp.go.nict.langrid.commons.transformer.StringToBooleanTransformer;
import jp.go.nict.langrid.commons.transformer.StringToDoubleTransformer;
import jp.go.nict.langrid.commons.transformer.StringToEnumTransformer;
import jp.go.nict.langrid.commons.transformer.StringToFloatTransformer;
import jp.go.nict.langrid.commons.transformer.StringToIntegerTransformer;
import jp.go.nict.langrid.commons.transformer.StringToLongTransformer;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public abstract class ParameterContext {
    private ParameterLoader loader = new ParameterLoader();
    private static Transformer<String, Boolean> s2b = new StringToBooleanTransformer();
    private static Transformer<String, Integer> s2i = new StringToIntegerTransformer();
    private static Transformer<String, Long> s2l = new StringToLongTransformer();
    private static Transformer<String, Float> s2f = new StringToFloatTransformer();
    private static Transformer<String, Double> s2d = new StringToDoubleTransformer();
    private static Transformer<String, String> s2s = new PassthroughTransformer<String>();
    private static Transformer<String, String[]> s2sa = new StringSplittingTransformer(",");
    private static Logger logger = Logger.getLogger(ParameterContext.class.getName());

    public abstract String getValue(String var1);

    public boolean getBoolean(String parameterName, boolean defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2b);
    }

    public Boolean getBoolean(String parameterName) {
        return this.getWithTransformer(parameterName, s2b);
    }

    public int getInteger(String parameterName, int defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2i);
    }

    public Integer getInteger(String parameterName) {
        return this.getWithTransformer(parameterName, s2i);
    }

    public long getLong(String parameterName, long defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2l);
    }

    public Long getLong(String parameterName) {
        return this.getWithTransformer(parameterName, s2l);
    }

    public float getFloat(String parameterName, float defaultValue) {
        return this.getWithTransformer(parameterName, Float.valueOf(defaultValue), s2f).floatValue();
    }

    public Float getFloat(String parameterName) {
        return this.getWithTransformer(parameterName, s2f);
    }

    public double getDouble(String parameterName, double defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2d);
    }

    public Double getDouble(String parameterName) {
        return this.getWithTransformer(parameterName, s2d);
    }

    public String getString(String parameterName, String defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2s);
    }

    public String getString(String parameterName, Supplier<String> supplier) {
        return this.getWithTransformer(parameterName, supplier, s2s);
    }

    public String[] getStrings(String parameterName, String[] defaultValue) {
        return this.getWithTransformer(parameterName, defaultValue, s2sa);
    }

    public <T extends Enum<T>> T getEnum(String parameterName, T defaultValue, Class<T> clazz) {
        return this.getWithTransformer(parameterName, defaultValue, new StringToEnumTransformer<T>(clazz));
    }

    public <T extends Enum<T>> T getEnum(String parameterName, Class<T> clazz) {
        return (T)((Enum)this.getWithTransformer(parameterName, new StringToEnumTransformer<T>(clazz)));
    }

    public <T> T getWithTransformer(String parameterName, T defaultValue, Transformer<String, T> transformer) {
        String v = this.getValue(parameterName);
        if (v == null) {
            return defaultValue;
        }
        try {
            return transformer.transform(v);
        }
        catch (TransformationException e) {
            logger.log(Level.WARNING, "failed to convert parameter. name:\"" + parameterName + "\" value:\"" + v + "\"", e);
            return defaultValue;
        }
    }

    public <T> T getWithTransformer(String parameterName, Supplier<T> supplier, Transformer<String, T> transformer) {
        String v = this.getValue(parameterName);
        if (v == null) {
            return supplier.get();
        }
        try {
            return transformer.transform(v);
        }
        catch (TransformationException e) {
            logger.log(Level.WARNING, "failed to convert parameter. name:\"" + parameterName + "\" value:\"" + v + "\"", e);
            return supplier.get();
        }
    }

    public <T> T getWithTransformer(String parameterName, Transformer<String, T> transformer) {
        String v = this.getValue(parameterName);
        if (v == null) {
            return null;
        }
        try {
            return transformer.transform(v);
        }
        catch (TransformationException e) {
            logger.log(Level.WARNING, "failed to convert parameter. name:\"" + parameterName + "\" value:\"" + v + "\"", e);
            return null;
        }
    }

    public void load(Object bean) throws ParameterRequiredException {
        this.loader.load(bean, this);
    }
}

