/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.util.ArrayList;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class StringSplittingTransformer
implements Transformer<String, String[]> {
    private String regex;
    private boolean trimElements = true;

    public StringSplittingTransformer(String regex) {
        this.regex = regex;
    }

    public StringSplittingTransformer(String regex, boolean trimElements) {
        this.regex = regex;
        this.trimElements = trimElements;
    }

    @Override
    public String[] transform(String value) {
        String[] values = value.split(this.regex);
        if (this.trimElements) {
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : values) {
                String v = s.trim();
                if (v.length() <= 0) continue;
                ret.add(v);
            }
            return ret.toArray(new String[0]);
        }
        return values;
    }
}

