/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util.zip;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import jp.go.nict.langrid.commons.io.FileUtil;
import jp.go.nict.langrid.commons.io.StreamUtil;

public class ZipFileUtil {
    public static void unzip(File zipFile, File targetDir) throws IOException {
        if (!FileUtil.assertDirectoryExists(targetDir)) {
            throw new IOException("failed to make directory: " + targetDir);
        }
        try (FileInputStream is = new FileInputStream(zipFile);){
            ZipFileUtil.doUnzip(is, targetDir);
        }
    }

    public static void unzip(InputStream is, File targetDir) throws IOException {
        if (!FileUtil.assertDirectoryExists(targetDir)) {
            throw new IOException("failed to make directory: " + targetDir);
        }
        ZipFileUtil.doUnzip(is, targetDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doUnzip(InputStream is, File targetDir) throws IOException {
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry entry = null;
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.isDirectory()) {
                new File(targetDir, entry.getName()).mkdirs();
                continue;
            }
            try (FileOutputStream os = new FileOutputStream(new File(targetDir, entry.getName()));){
                StreamUtil.transfer(zis, os);
            }
        }
    }
}

