/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.util;

import java.net.URI;
import java.net.URISyntaxException;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.ws.util.InvalidLangridUriException;

public class LangridUriUtil {
    public static Pair<String, String> extractServiceIds(URI uri) throws InvalidLangridUriException {
        String scheme = uri.getScheme();
        String[] parts = uri.getSchemeSpecificPart().split(":");
        if (!scheme.equalsIgnoreCase("servicegrid") || parts.length != 3 || !parts[0].equalsIgnoreCase("service") || parts[1].contains(":") || parts[2].contains(":")) {
            throw new InvalidLangridUriException(uri);
        }
        return Pair.create(parts[1], parts[2]);
    }

    public static Pair<String, String> extractServiceTypeIds(URI uri) throws InvalidLangridUriException {
        String scheme = uri.getScheme();
        String[] parts = uri.getSchemeSpecificPart().split(":");
        if (!scheme.equalsIgnoreCase("servicegrid") || parts.length != 3 || !parts[0].equalsIgnoreCase("servicetype") || parts[1].contains(":") || parts[2].contains(":")) {
            throw new InvalidLangridUriException(uri);
        }
        return Pair.create(parts[1], parts[2]);
    }

    public static URI createServiceUri(String gridId, String serviceId) {
        try {
            return new URI("servicegrid:service:" + gridId + ":" + serviceId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static URI createServiceTypeUri(String domainId, String serviceTypeId) {
        try {
            return new URI("servicegrid:servicetype:" + domainId + ":" + serviceTypeId);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

