/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Converter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.PlainConverter;

final class BooleanConverter
implements Converter {
    public static final BooleanConverter INSTANCE = new BooleanConverter();

    BooleanConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof Boolean) {
            return value;
        }
        if (value instanceof BigDecimal) {
            return !value.equals(BigDecimal.ZERO);
        }
        if (value instanceof BigInteger) {
            return !value.equals(BigInteger.ZERO);
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        if (value != null) {
            String s = value.toString().trim();
            if (s.length() == 0 || s.equalsIgnoreCase("0") || s.equalsIgnoreCase("f") || s.equalsIgnoreCase("false") || s.equalsIgnoreCase("no") || s.equalsIgnoreCase("off") || s.equals("NaN")) {
                return false;
            }
            return true;
        }
        return PlainConverter.getDefaultValue(c);
    }
}

