/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Converter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONHint;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.util.ClassUtil;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.util.PropertyInfo;

final class ObjectConverter
implements Converter {
    public static final ObjectConverter INSTANCE = new ObjectConverter();

    ObjectConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        Map<String, PropertyInfo> props = context.getSetProperties(c);
        if (value instanceof Map) {
            Object o = json.create(context, c);
            if (o == null) {
                return null;
            }
            for (Map.Entry entry : ((Map)value).entrySet()) {
                String name = entry.getKey().toString();
                PropertyInfo target = props.get(name);
                if (target == null) {
                    target = props.get(ObjectConverter.toLowerCamel(context, name));
                }
                if (target == null) continue;
                context.enter(name, target.getWriteAnnotation(JSONHint.class));
                Class<?> cls = target.getWriteType();
                Type gtype = target.getWriteGenericType();
                if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                    gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                    cls = ClassUtil.getRawType(gtype);
                }
                target.set(o, json.postparse(context, entry.getValue(), cls, gtype));
                context.exit();
            }
            return o;
        }
        if (value instanceof List) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        JSONHint hint = context.getHint();
        if (hint != null && hint.anonym().length() > 0) {
            PropertyInfo target = props.get(hint.anonym());
            if (target == null) {
                return null;
            }
            Object o = json.create(context, c);
            if (o == null) {
                return null;
            }
            context.enter(hint.anonym(), target.getWriteAnnotation(JSONHint.class));
            Class<?> cls = target.getWriteType();
            Type gtype = target.getWriteGenericType();
            if (gtype instanceof TypeVariable && t instanceof ParameterizedType) {
                gtype = ObjectConverter.resolveTypeVariable((TypeVariable)gtype, (ParameterizedType)t);
                cls = ClassUtil.getRawType(gtype);
            }
            target.set(o, json.postparse(context, value, cls, gtype));
            context.exit();
            return o;
        }
        throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
    }

    private static String toLowerCamel(JSON.Context context, String name) {
        StringBuilder sb = context.getCachedBuffer();
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && !Character.isUpperCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    private static Type resolveTypeVariable(TypeVariable<?> type, ParameterizedType parent) {
        Class<?> rawType = ClassUtil.getRawType(parent);
        if (rawType.equals(type.getGenericDeclaration())) {
            String tvName = type.getName();
            TypeVariable<Class<?>>[] rtypes = rawType.getTypeParameters();
            Type[] atypes = parent.getActualTypeArguments();
            for (int i = 0; i < rtypes.length; ++i) {
                if (!tvName.equals(rtypes[i].getName())) continue;
                return atypes[i];
            }
        }
        return type.getBounds()[0];
    }
}

