/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.rpc;

import java.lang.reflect.Member;
import jp.go.nict.langrid.commons.lang.ExceptionUtil;
import jp.go.nict.langrid.commons.rpc.RpcFault;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONException;

public class RpcFaultUtil {
    private static JSON json = new JSON(){

        @Override
        protected boolean ignore(JSON.Context context, Class<?> target, Member member) {
            if (member.getDeclaringClass().equals(Throwable.class)) {
                return true;
            }
            return super.ignore(context, target, member);
        }
    };

    public static Exception rpcFaultToThrowable(RpcFault fault) {
        String[] v = fault.getFaultString().split(":", 2);
        if (v.length == 1) {
            return new RuntimeException(v[0]);
        }
        Class<?> clazz = null;
        try {
            clazz = Class.forName(v[0]);
        }
        catch (ClassNotFoundException e) {
            return new RuntimeException(json.format(fault));
        }
        try {
            Exception e = (Exception)json.parse((CharSequence)v[1], clazz);
            e.fillInStackTrace();
            return e;
        }
        catch (JSONException e) {
            try {
                try {
                    Exception e2 = (Exception)clazz.getConstructor(String.class).newInstance(v[1]);
                    e2.fillInStackTrace();
                    return e2;
                }
                catch (Exception e2) {
                    e = (Exception)clazz.newInstance();
                    e.fillInStackTrace();
                    return e;
                }
            }
            catch (IllegalArgumentException e3) {
                return new RuntimeException(json.format(fault));
            }
            catch (SecurityException e4) {
                return new RuntimeException(json.format(fault));
            }
            catch (InstantiationException e5) {
                return new RuntimeException(json.format(fault));
            }
            catch (IllegalAccessException e6) {
                return new RuntimeException(json.format(fault));
            }
        }
    }

    public static RpcFault throwableToRpcFault(String faultCode, Throwable t) {
        RpcFault f = new RpcFault();
        f.setFaultCode(faultCode);
        f.setFaultString(t.getClass().getName() + ":" + json.format(t));
        f.setDetail(ExceptionUtil.getMessageWithStackTrace(t));
        return f;
    }
}

