/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jp.go.nict.langrid.commons.beanutils.ArrayToArrayTransformer;
import jp.go.nict.langrid.commons.beanutils.ConversionException;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.lang.reflect.TypeUtil;
import jp.go.nict.langrid.commons.rpc.intf.ComponentConverter;
import jp.go.nict.langrid.commons.transformer.FromToStringTransformer;
import jp.go.nict.langrid.commons.transformer.ObjectToEnumTransformer;
import jp.go.nict.langrid.commons.transformer.StringToEnumTransformer;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.transformer.Transformers;
import jp.go.nict.langrid.commons.util.MapUtil;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONHint;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.util.Base64;

public class Converter2
extends Converter {
    private Transformers transformers = new Transformers();
    private Map<Class<?>, Class<?>> aliases = new HashMap();
    private static Map<Class<?>, Constructor<?>> primitiveToWrapperConstructor = MapUtil.newHashMap();
    private static Map<Class<?>, Method> stringToWrapperMethods = MapUtil.newHashMap();

    public Converter2() {
        this.addFromToStringConverter(URL.class);
    }

    @Override
    public <T> void addArrayConversion(Class<T> dst) throws IllegalArgumentException {
        if (!dst.isArray()) {
            throw new IllegalArgumentException("dst must be array class.");
        }
    }

    @Override
    public <T, U> void addArrayConversion(Class<T[]> src, Class<U[]> dst) throws IllegalArgumentException {
        if (!src.isArray()) {
            throw new IllegalArgumentException("src must be an array class.");
        }
        if (!dst.isArray()) {
            throw new IllegalArgumentException("dst must be an array class.");
        }
        this.transformers.addTransformer(src, dst, new ArrayToArrayTransformer(this, dst));
    }

    @Override
    public <T extends Enum<T>> void addEnumConversion(Class<T> dst) throws IllegalArgumentException {
        ObjectToEnumTransformer<T> transformer = new ObjectToEnumTransformer<T>(dst);
        this.transformers.addTransformer(Object.class, dst, transformer);
        this.transformers.addTransformer(String.class, dst, new StringToEnumTransformer<T>(dst));
    }

    @Override
    public <T, U extends T> void addConcreteClassAlias(Class<T> src, Class<U> dst) throws IllegalArgumentException {
        this.aliases.put(src, dst);
    }

    @Override
    public <T, U extends T> void addFromToStringConverter(Class<T> dst) {
    }

    @Override
    public <T, U> void addTransformerConversion(Transformer<T, U> transformer) throws IllegalArgumentException {
        Class<?>[] types = GenericsUtil.getTypeArgumentClasses(transformer.getClass(), Transformer.class);
        Class<?> t1 = TypeUtil.toClass(types[0]);
        Class<?> t2 = TypeUtil.toClass(types[1]);
        this.addTransformerConversion(t1, t2, transformer);
    }

    @Override
    public <T, U> void addTransformerConversion(Class<T> src, Class<U> dst, Transformer<T, U> transformer) {
        this.transformers.addTransformer(src, dst, transformer);
    }

    @Override
    public Object[] convertEachElement(Object[] objects, Class<?>[] types) {
        Object[] ret = new Object[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            ret[i] = this.convert(objects[i], types[i]);
        }
        return ret;
    }

    @Override
    public Object[] convertEachElement(Object array, Class<?>[] types) {
        Object[] ret = new Object[Array.getLength(array)];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = this.convert(Array.get(array, i), types[i]);
        }
        return ret;
    }

    @Override
    public <T extends Collection<?>> T convertCollection(Collection<?> value, ComponentConverter componentConverter) throws ConversionException {
        ArrayList ret = new ArrayList();
        for (Object element : value) {
            ret.add(componentConverter.convert(element));
        }
        return (T)ret;
    }

    @Override
    public <T> Collection<T> convertCollection(Collection<?> value, Class<?> compositeType, Class<T> componentType) throws ConversionException {
        AbstractCollection ret = null;
        ret = compositeType.isAssignableFrom(LinkedHashSet.class) ? new LinkedHashSet() : new ArrayList();
        for (Object element : value) {
            ret.add(this.convert(element, componentType));
        }
        return ret;
    }

    @Override
    public <T> Collection<T> convertCollection(Collection<?> value, Class<?> compositeType, Type componentType) throws ConversionException {
        AbstractCollection ret = null;
        ret = compositeType.isAssignableFrom(LinkedHashSet.class) ? new LinkedHashSet() : new ArrayList();
        for (Object element : value) {
            ret.add(this.convert(element, componentType));
        }
        return ret;
    }

    public <T> T convertCollectionToArrayNew(Collection<?> value, Class<T> componentType) throws ConversionException {
        if (value == null) {
            return null;
        }
        int length = value.size();
        Object array = Array.newInstance(componentType, length);
        int i = 0;
        for (Object v : value) {
            T element = this.convert(v, componentType);
            try {
                Array.set(array, i++, element);
            }
            catch (IllegalArgumentException e) {
                throw new ConversionException(e);
            }
        }
        return (T)array;
    }

    @Override
    public <T> T convertMapToBean(Map<String, Object> value, Class<T> targetClass) throws ConversionException {
        if (value == null) {
            return null;
        }
        try {
            T o = targetClass.newInstance();
            for (Map.Entry<String, Object> prop : value.entrySet()) {
                Collection<Object> v;
                JSONHint h;
                String name = prop.getKey();
                Method m = ClassUtil.findSetter(targetClass, name);
                if (m == null || (h = m.getAnnotation(JSONHint.class)) != null && h.ignore()) continue;
                try {
                    Field f = targetClass.getField(name);
                    JSONHint fh = f.getAnnotation(JSONHint.class);
                    if (fh != null && fh.ignore()) {
                        continue;
                    }
                }
                catch (NoSuchFieldException f) {
                    // empty catch block
                }
                if ((v = value.get(name)) == null) continue;
                Type setterPropType = m.getGenericParameterTypes()[0];
                Class<?> setterPropClass = m.getParameterTypes()[0];
                if (Collection.class.isAssignableFrom(setterPropClass)) {
                    v = this.convertCollection((Collection)v, setterPropClass, ((ParameterizedType)setterPropType).getActualTypeArguments()[0]);
                } else if (!setterPropClass.isAssignableFrom(v.getClass()) && (v = !setterPropClass.isPrimitive() ? this.convert(v, setterPropType) : this.convert(v, setterPropClass)) == null) continue;
                m.invoke(o, v);
            }
            return o;
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(e);
        }
        catch (InstantiationException e) {
            throw new ConversionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException(e);
        }
    }

    @Override
    public <T> T convert(Object value, Type type) throws ConversionException {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            if (value instanceof Collection && Collection.class.isAssignableFrom((Class)pt.getRawType())) {
                return (T)this.convertCollection((Collection)value, (Class)pt.getRawType(), (Class)pt.getActualTypeArguments()[0]);
            }
            return this.convert(value, pt.getRawType());
        }
        if (type instanceof Class) {
            return this.convert(value, (Class)type);
        }
        throw new ConversionException("unsupported conversion from " + value.getClass().getName() + " to " + type);
    }

    @Override
    public <T> T convert(Object value, Class<T> target) throws ConversionException {
        Transformer<?, Object> transformer;
        if (value == null) {
            return null;
        }
        if (target.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        Class<?> alias = this.aliases.get(target);
        if (alias != null) {
            target = alias;
        }
        if (target.isPrimitive()) {
            target = ClassUtil.getWrapperClass(target.getName());
        }
        if ((transformer = this.transformers.get(value.getClass(), target)) != null) {
            try {
                return transformer.transform(value);
            }
            catch (TransformationException e) {
                throw new ConversionException(String.format("failed to convert value:\"%s\" to %s using transformer:%s", value, target, transformer), e);
            }
        }
        if (value.getClass().isArray() && target.isArray()) {
            this.addArrayConversion(value.getClass(), target);
            return (T)this.convert(value, target);
        }
        if (value instanceof Collection && target.isArray()) {
            return (T)this.convertCollectionToArrayNew((Collection)value, target.getComponentType());
        }
        if (value instanceof Collection && Set.class.isAssignableFrom(target)) {
            return (T)new HashSet((Collection)value);
        }
        if (value instanceof Map && !target.isArray()) {
            return (T)this.convertMapToBean((Map)value, target);
        }
        if (target.isEnum()) {
            this.addEnumConversion(target);
            return (T)this.convert(value, target);
        }
        if (target.equals(byte[].class)) {
            return (T)Base64.decode(value.toString());
        }
        if (target.isPrimitive()) {
            try {
                Constructor<?> c = primitiveToWrapperConstructor.get(target);
                if (c != null && c.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                    return (T)c.newInstance(value);
                }
                return (T)stringToWrapperMethods.get(target).invoke(null, value.toString());
            }
            catch (IllegalAccessException e) {
                throw new ConversionException(e);
            }
            catch (InstantiationException e) {
                throw new ConversionException(e);
            }
            catch (InvocationTargetException e) {
                throw new ConversionException(e);
            }
        }
        if (target.equals(String.class)) {
            return (T)value.toString();
        }
        if (target.equals(Date.class)) {
            if (value instanceof Number) {
                return (T)new Date(((Number)value).longValue());
            }
            if (value instanceof String) {
                try {
                    return (T)new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS Z").parse((String)value);
                }
                catch (ParseException e) {
                    throw new ConversionException(e);
                }
            }
            throw new ConversionException(value + " can't be converted to Date");
        }
        if (target.equals(Calendar.class)) {
            Calendar cal = Calendar.getInstance();
            if (value instanceof Number) {
                cal.setTimeInMillis(((Number)value).longValue());
            } else if (value instanceof String) {
                try {
                    cal.setTime(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS Z").parse((String)value));
                }
                catch (ParseException e) {
                    throw new ConversionException(e);
                }
            } else {
                throw new ConversionException(value + " can't be converted to Calendar");
            }
            return (T)cal;
        }
        if (target.equals(Character.class)) {
            if (value instanceof String) {
                char ch = ((String)value).charAt(0);
                return (T)new Character(ch);
            }
            throw new ConversionException(value + " can't be converted to Character");
        }
        if (target.equals(Byte.class)) {
            if (value instanceof Number) {
                byte b = ((Number)value).byteValue();
                return (T)new Byte(b);
            }
            throw new ConversionException(value + " can't be converted to Byte");
        }
        if (target.equals(char[].class)) {
            if (value instanceof String) {
                String v = (String)value;
                return (T)v.toCharArray();
            }
            throw new ConversionException(value + " can't be converted to char[]");
        }
        try {
            Constructor<Object> c = target.getConstructor(new Class[0]);
            Object ret = c.newInstance(new Object[0]);
            this.copyProperties(ret, value);
            return (T)ret;
        }
        catch (NoSuchMethodException c) {
        }
        catch (InstantiationException c) {
        }
        catch (IllegalAccessException c) {
        }
        catch (IllegalArgumentException c) {
        }
        catch (InvocationTargetException c) {
            // empty catch block
        }
        try {
            Constructor<Object> c = target.getConstructor(String.class);
            this.addTransformerConversion(value.getClass(), target, new FromToStringTransformer<Object>(c));
            return (T)this.convert(value, target);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ConversionException("no suitable conversion logic for class " + target.toString());
        }
    }

    @Override
    public void copyProperties(Object target, Object source) throws ConversionException {
        block4: for (Pair<String, Method> prop : ClassUtil.getReadableProperties(source.getClass())) {
            for (Method s : ClassUtil.findSetters(target.getClass(), prop.getFirst())) {
                try {
                    s.invoke(target, this.convert(prop.getSecond().invoke(source, new Object[0]), s.getGenericParameterTypes()[0]));
                    continue block4;
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (ConversionException conversionException) {
                }
            }
        }
    }

    static {
        try {
            primitiveToWrapperConstructor.put(Boolean.TYPE, Boolean.class.getConstructor(Boolean.TYPE));
            primitiveToWrapperConstructor.put(Byte.TYPE, Byte.class.getConstructor(Byte.TYPE));
            primitiveToWrapperConstructor.put(Character.TYPE, Character.class.getConstructor(Character.TYPE));
            primitiveToWrapperConstructor.put(Short.TYPE, Short.class.getConstructor(Short.TYPE));
            primitiveToWrapperConstructor.put(Integer.TYPE, Integer.class.getConstructor(Integer.TYPE));
            primitiveToWrapperConstructor.put(Long.TYPE, Long.class.getConstructor(Long.TYPE));
            primitiveToWrapperConstructor.put(Float.TYPE, Float.class.getConstructor(Float.TYPE));
            primitiveToWrapperConstructor.put(Double.TYPE, Double.class.getConstructor(Double.TYPE));
            stringToWrapperMethods.put(Boolean.TYPE, Boolean.class.getMethod("parseBoolean", String.class));
            stringToWrapperMethods.put(Byte.TYPE, Byte.class.getMethod("parseByte", String.class));
            stringToWrapperMethods.put(Character.TYPE, CharacterParser.class.getMethod("parseCharacter", String.class));
            stringToWrapperMethods.put(Short.TYPE, Short.class.getMethod("parseShort", String.class));
            stringToWrapperMethods.put(Integer.TYPE, Integer.class.getMethod("parseInt", String.class));
            stringToWrapperMethods.put(Long.TYPE, Long.class.getMethod("parseLong", String.class));
            stringToWrapperMethods.put(Float.TYPE, Float.class.getMethod("parseFloat", String.class));
            stringToWrapperMethods.put(Double.TYPE, Double.class.getMethod("parseDouble", String.class));
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private static class CharacterParser {
        private CharacterParser() {
        }

        public static Character parseCharacter(String value) {
            if (value.length() == 0) {
                return null;
            }
            return Character.valueOf(value.charAt(0));
        }
    }
}

