/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang.reflect;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractInvocationRecorder<T> {
    private List<Record> records = new ArrayList<Record>();
    private Class<T> targetClazz;

    public AbstractInvocationRecorder(Class<T> targetClazz) {
        this.targetClazz = targetClazz;
    }

    public void play(T target) throws InvocationTargetException, IllegalAccessException {
        for (Record r : this.records) {
            r.play(target);
        }
    }

    protected void record(Object ... args) {
        StackTraceElement ste = new Exception().getStackTrace()[1];
        String methodName = ste.getMethodName();
        Method method = null;
        for (Method m : this.targetClazz.getMethods()) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != args.length) continue;
            if (method != null) {
                throw new RuntimeException("failed to detect suitable method");
            }
            method = m;
        }
        if (method == null) {
            throw new RuntimeException("method not found: " + methodName);
        }
        this.records.add(new Record(method, args));
    }

    private static class Record {
        private Method method;
        private Object[] args;

        public Record(Method method, Object[] args) {
            this.method = method;
            this.args = args;
        }

        public void play(Object target) throws InvocationTargetException, IllegalAccessException {
            this.method.invoke(target, this.args);
        }
    }
}

