/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.param;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.parameter.ParameterContext;
import jp.go.nict.langrid.commons.ws.HttpServletRequestUtil;

public class URLParameterContext
extends ParameterContext {
    private Map<String, List<String>> params;

    public URLParameterContext(URL url) {
        this.params = HttpServletRequestUtil.queryToMap(url.getQuery());
    }

    public URLParameterContext(String query) {
        try {
            this.params = HttpServletRequestUtil.queryToMap(URLDecoder.decode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getValue(String name) {
        List<String> v = this.params.get(name);
        if (v != null) {
            return StringUtil.join(v.toArray(new String[0]), ",");
        }
        return null;
    }
}

