/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Converter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.PlainConverter;

final class IntegerConverter
implements Converter {
    public static final IntegerConverter INSTANCE = new IntegerConverter();

    IntegerConverter() {
    }

    @Override
    public Object convert(JSON json, JSON.Context context, Object value, Class<?> c, Type t) throws Exception {
        NumberFormat f;
        if (value instanceof Map) {
            value = ((Map)value).get(null);
        } else if (value instanceof List) {
            List src = (List)value;
            Object object = value = !src.isEmpty() ? (Object)src.get(0) : null;
        }
        if (value instanceof String && (f = context.getNumberFormat()) != null) {
            value = f.parse((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1 : 0;
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).intValueExact();
        }
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof String) {
            String str = value.toString().trim();
            if (str.length() > 0) {
                int start = 0;
                if (str.charAt(0) == '+') {
                    ++start;
                }
                if (str.startsWith("0x", start)) {
                    return Integer.parseInt(str.substring(start + 2), 16);
                }
                return Integer.parseInt(str.substring(start));
            }
            return PlainConverter.getDefaultValue(c);
        }
        if (value != null) {
            throw new UnsupportedOperationException("Cannot convert " + value.getClass() + " to " + t);
        }
        return PlainConverter.getDefaultValue(c);
    }
}

