/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.cs.binding;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.go.nict.langrid.commons.codec.URLCodec;
import jp.go.nict.langrid.commons.cs.binding.BindingNode;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.CollectionUtil;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.util.function.Function;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONException;

public class DynamicBindingUtil {
    private static Transformer<Map.Entry<String, String>, String> defaultBindingToString = value -> (String)value.getKey() + ":" + URLCodec.encode((String)value.getValue());
    private static Transformer<String, Pair<String, String>> stringToDefaultBinding = value -> {
        String[] values = value.split(":");
        if (values.length != 2) {
            throw new TransformationException("value format is invalid. \"" + value + "\"");
        }
        return Pair.create(values[0], URLCodec.decode(values[1]));
    };
    private static Transformer<Map.Entry<String, Map<String, String>>, String> bindingOverrideToString = value -> StringUtil.join(CollectionUtil.collect(((Map)value.getValue()).entrySet(), new BindingOverrideEntryToString((String)value.getKey())).toArray(new String[0]), ",");

    public static String encodeDefaults(Map<String, String> bindings) {
        return StringUtil.join(CollectionUtil.collect(bindings.entrySet(), defaultBindingToString).toArray(new String[0]), ",");
    }

    public static Map<String, String> decodeDefaults(String value) {
        return DynamicBindingUtil.decodeMappings(value, stringToDefaultBinding, new HashMap());
    }

    public static String encodeOverrides(Map<String, Map<String, String>> bindings) {
        return StringUtil.join(CollectionUtil.collect(DynamicBindingUtil.filter(bindings).entrySet(), bindingOverrideToString).toArray(new String[0]), ",");
    }

    private static Map<String, Map<String, String>> filter(Map<String, Map<String, String>> map) {
        Iterator<Map.Entry<String, Map<String, String>>> i = map.entrySet().iterator();
        while (i.hasNext()) {
            if (i.next().getValue().size() != 0) continue;
            i.remove();
        }
        return map;
    }

    public static Map<String, Map<String, String>> decodeOverrides(String value) {
        HashMap<String, Map<String, String>> mappings = new HashMap<String, Map<String, String>>();
        for (String line : value.split(",")) {
            String[] values2;
            String[] values = line.split("@");
            if (values.length != 2 || (values2 = values[0].split(":")).length != 2) continue;
            String wfId = values[1];
            String sourceId = values2[0];
            String dstId = URLCodec.decode(values2[1]);
            HashMap<String, String> b = (HashMap<String, String>)mappings.get(wfId);
            if (b == null) {
                b = new HashMap<String, String>();
                mappings.put(wfId, b);
            }
            b.put(sourceId, dstId);
        }
        return mappings;
    }

    public static String encodeTree(Collection<BindingNode> value) {
        return JSON.encode(value);
    }

    public static String encodeTree(Collection<BindingNode> value, int indentFactor) {
        return JSON.encode(value, true);
    }

    public static Collection<BindingNode> decodeTree(String value) throws ParseException {
        try {
            return (Collection)JSON.decode(value, new ArrayList<BindingNode>(){}.getClass().getGenericSuperclass());
        }
        catch (JSONException e) {
            throw new ParseException(e.getMessage(), -1);
        }
    }

    private static <T, U> Map<T, U> decodeMappings(String value, Transformer<String, Pair<T, U>> transformer, Map<T, U> map) throws TransformationException {
        for (String line : value.split(",")) {
            Pair<T, U> v = transformer.transform(line);
            if (v == null) continue;
            map.put(v.getFirst(), v.getSecond());
        }
        return map;
    }

    private static class BindingOverrideEntryToString
    implements Function<Map.Entry<String, String>, String> {
        private String serviceId;

        public BindingOverrideEntryToString(String serviceId) {
            this.serviceId = serviceId;
        }

        @Override
        public String apply(Map.Entry<String, String> value) {
            return value.getKey() + ":" + URLCodec.encode(value.getValue()) + "@" + this.serviceId;
        }
    }
}

