/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.dom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jp.go.nict.langrid.commons.dom.DocumentUtil;
import jp.go.nict.langrid.commons.dom.NodeUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementUtil
extends NodeUtil {
    public static void removeChildren(Element parent, String tagName) {
        for (Element e : ElementUtil.getChildNodes(parent, tagName)) {
            parent.removeChild(e);
        }
    }

    public static void removeChildren(Element parent) {
        for (Element e : ElementUtil.getChildNodes(parent)) {
            parent.removeChild(e);
        }
    }

    public static void replaceElements(Element parent, Element element) {
        ElementUtil.removeChildren(parent, element.getNodeName());
        parent.appendChild(element);
    }

    public static Document prepareParentDocument(Element element) {
        Document document = null;
        Node parent = element.getParentNode();
        if (parent != null) {
            if (parent instanceof Document) {
                document = (Document)parent;
            } else {
                element = (Element)element.cloneNode(true);
            }
        }
        if (document == null) {
            document = DocumentUtil.newDocument();
            document.adoptNode(element);
            document.appendChild(element);
        }
        return document;
    }

    public static Iterable<Element> getChildNodes(Element parent) {
        final NodeList nodes = parent.getChildNodes();
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new Iterator<Element>(){
                    private int c = 0;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean hasNext() {
                        return nodes.getLength() > this.c;
                    }

                    @Override
                    public Element next() {
                        if (this.c >= nodes.getLength()) {
                            throw new NoSuchElementException();
                        }
                        return (Element)nodes.item(this.c++);
                    }
                };
            }
        };
    }

    public static Collection<Element> getChildNodes(Element parent, String tagName) {
        return new ElementListCollection(parent.getElementsByTagName(tagName));
    }

    public static String getChildNodeText(Element parent, String childTagName) {
        Element node = ElementUtil.getFirstChild(parent, childTagName);
        if (node == null) {
            return null;
        }
        return node.getTextContent();
    }

    public static Element getFirstChild(Element parent, String childTagName) {
        NodeList nodes = parent.getElementsByTagName(childTagName);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    public static final String toString(Element element) {
        return DocumentUtil.toString(ElementUtil.prepareParentDocument(element));
    }

    private static class ElementListCollection
    implements Collection<Element> {
        private NodeList nodes;

        public ElementListCollection(NodeList nodes) {
            this.nodes = nodes;
        }

        @Override
        public boolean add(Element o) {
            throw new UnsupportedOperationException("ElementListCollection.add");
        }

        @Override
        public boolean addAll(Collection<? extends Element> c) {
            throw new UnsupportedOperationException("ElementListCollection.addAll");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("ElementListCollection.clear");
        }

        @Override
        public boolean contains(Object o) {
            for (Element e : this) {
                if (!e.equals(o)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            for (Object o : c) {
                if (this.contains(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof ElementListCollection)) {
                return false;
            }
            ElementListCollection v = (ElementListCollection)o;
            int n = this.size();
            if (n != v.size()) {
                return false;
            }
            Iterator<Element> s = this.iterator();
            Iterator<Element> d = v.iterator();
            while (s.hasNext()) {
                if (s.next().equals(d.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int hashCode = 0;
            for (Element e : this) {
                hashCode = hashCode * 31 + e.hashCode();
            }
            return hashCode;
        }

        @Override
        public boolean isEmpty() {
            return this.size() == 0;
        }

        @Override
        public Iterator<Element> iterator() {
            return new Iterator<Element>(){
                private int c = 0;

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public boolean hasNext() {
                    return nodes.getLength() > this.c;
                }

                @Override
                public Element next() {
                    if (this.c >= nodes.getLength()) {
                        throw new NoSuchElementException();
                    }
                    return (Element)nodes.item(this.c++);
                }
            };
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("ElementListCollection.remove");
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException("ElementListCollection.removeAll");
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException("ElementListCollection.retainAll");
        }

        @Override
        public int size() {
            return this.nodes.getLength();
        }

        @Override
        public Object[] toArray() {
            Object[] objects = new Object[this.nodes.getLength()];
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = this.nodes.item(i);
            }
            return objects;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (!Element.class.isAssignableFrom(a.getClass().getComponentType())) {
                throw new ArrayStoreException();
            }
            Object[] elements = a;
            if (elements.length < this.nodes.getLength()) {
                elements = (Object[])Array.newInstance(a.getClass().getComponentType(), this.nodes.getLength());
            }
            for (int i = 0; i < this.nodes.getLength(); ++i) {
                elements[i] = this.nodes.item(i);
            }
            return elements;
        }
    }
}

