/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.IOException;
import jp.go.nict.langrid.commons.lang.CharSequenceUtil;

public class IndentedWriter {
    private Appendable appendable;
    private int indent = 0;

    public IndentedWriter(Appendable appendable) {
        this.appendable = appendable;
    }

    public IndentedWriter(Appendable appendable, int indent) {
        this.appendable = appendable;
        this.indent = indent;
    }

    public int getIndent() {
        return this.indent;
    }

    public IndentedWriter println(String format, Object ... args) throws IOException {
        this.tabs(this.indent);
        this.appendable.append(String.format(format, args)).append('\n');
        return this;
    }

    public IndentedWriter indent() {
        ++this.indent;
        return this;
    }

    public IndentedWriter unindent() {
        --this.indent;
        return this;
    }

    public IndentedWriter write(String format, Object ... args) throws IOException {
        this.println(format, args);
        return this;
    }

    public IndentedWriter indent(String format, Object ... args) throws IOException {
        this.tabs(this.indent++);
        this.appendable.append(String.format(format, args)).append('\n');
        return this;
    }

    public IndentedWriter unindent(String format, Object ... args) throws IOException {
        this.tabs(--this.indent);
        this.appendable.append(String.format(format, args)).append('\n');
        return this;
    }

    private void tabs(int n) throws IOException {
        this.appendable.append(CharSequenceUtil.repeat('\t', n));
    }
}

