/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LimitedFilteredOutputStream
extends FilterOutputStream {
    private int limitSize;

    public LimitedFilteredOutputStream(OutputStream original, int limitSize) {
        super(original);
        this.limitSize = limitSize;
    }

    public int getLimitSize() {
        return this.limitSize;
    }

    public void setLimitSize(int limitSize) {
        this.limitSize = limitSize;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.limitSize > 0) {
            super.write(b);
            --this.limitSize;
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int s = Math.min(len, this.limitSize);
        if (s > 0) {
            super.write(b, off, s);
            this.limitSize -= s;
        }
    }
}

