/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.ArrayList;
import java.util.Collection;
import jp.go.nict.langrid.commons.lang.block.BlockPE;
import jp.go.nict.langrid.commons.nio.charset.CharsetUtil;
import jp.go.nict.langrid.commons.util.function.Filters;
import jp.go.nict.langrid.commons.util.function.Predicate;

public final class StreamUtil {
    public static Collection<String> readLines(InputStream is, CharsetDecoder decoder) throws IOException {
        return StreamUtil.readLines(new InputStreamReader(is, decoder), Filters.pass());
    }

    public static Collection<String> readLines(InputStream is, String encoding) throws IOException {
        return StreamUtil.readLines(new InputStreamReader(is, encoding), Filters.pass());
    }

    public static Collection<String> readLines(Reader reader, Predicate<String> test) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        ArrayList<String> lines = new ArrayList<String>();
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!test.test(line)) continue;
            lines.add(line);
        }
        return lines;
    }

    public static String readAsString(InputStream is, CharsetDecoder decoder) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, decoder);
        return StreamUtil.readAsString(reader);
    }

    public static String readAsString(InputStream is, String encodingName) throws IOException {
        InputStreamReader reader = new InputStreamReader(is, encodingName);
        return StreamUtil.readAsString(reader);
    }

    public static String readAsString(Reader reader) throws IOException {
        int size;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[1024];
        while ((size = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, size);
        }
        return writer.toString();
    }

    public static byte[] readAsBytes(InputStream is) throws IOException {
        int size;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((size = is.read(buffer)) != -1) {
            o.write(buffer, 0, size);
        }
        return o.toByteArray();
    }

    public static byte[] readAsBytes(InputStream is, int count) throws IOException {
        int size;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while (count > 0 && (size = is.read(buffer, 0, Math.min(1024, count))) != -1) {
            o.write(buffer, 0, size);
            count -= size;
        }
        return o.toByteArray();
    }

    public static int readFully(InputStream is, byte[] buff) throws IOException {
        int rest;
        int size;
        int capacity = buff.length;
        for (rest = buff.length; rest > 0 && (size = is.read(buff, capacity - rest, rest)) != -1; rest -= size) {
        }
        return capacity - rest;
    }

    public static void writeString(OutputStream os, String string, CharsetEncoder encoder) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, encoder);
        writer.write(string);
        writer.flush();
    }

    public static void writeString(OutputStream os, String string, String encodingName) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(os, encodingName);
        writer.write(string);
        writer.flush();
    }

    public static Reader createUTF8Reader(InputStream is) {
        return new InputStreamReader(is, CharsetUtil.newUTF8Decoder());
    }

    public static Writer createUTF8Writer(OutputStream os) {
        return new OutputStreamWriter(os, CharsetUtil.newUTF8Encoder());
    }

    public static int transfer(InputStream is, OutputStream os) throws IOException {
        int sum = 0;
        int r = 0;
        byte[] buff = new byte[4096];
        while ((r = is.read(buff)) != -1) {
            sum += r;
            os.write(buff, 0, r);
        }
        return sum;
    }

    public static int transfer(InputStream is, OutputStream os, int count) throws IOException {
        int sum = 0;
        int r = 0;
        byte[] buff = new byte[4096];
        while (count > 0 && (r = is.read(buff, 0, Math.min(count, buff.length))) != -1) {
            sum += r;
            count -= r;
            os.write(buff, 0, r);
        }
        return sum;
    }

    public static int transfer(Reader reader, Writer writer) throws IOException {
        int sum = 0;
        int r = 0;
        char[] buff = new char[4096];
        while ((r = reader.read(buff)) != -1) {
            sum += r;
            writer.write(buff, 0, r);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withPrintWriter(OutputStream os, String encoding, BlockPE<PrintWriter, IOException> block) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, encoding);
        try {
            PrintWriter pw = new PrintWriter(osw);
            try {
                block.execute(pw);
            }
            finally {
                pw.flush();
            }
        }
        finally {
            osw.flush();
        }
    }
}

