/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang.reflect;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;

public class LoggingProxy {
    private static final String lineSeparator;

    public static Object create(Object instance) {
        return LoggingProxy.create(instance, instance.getClass().getInterfaces(), System.out);
    }

    public static Object create(final Object instance, Class<?>[] interfaces, final Appendable out) {
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), interfaces, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                out.append(method.getDeclaringClass().getSimpleName()).append(".").append(method.getName()).append("(");
                boolean first = true;
                if (args != null) {
                    for (Object o : args) {
                        if (!first) {
                            out.append(", ");
                        } else {
                            first = false;
                        }
                        if (o != null && o.getClass().isArray()) {
                            LoggingProxy.appendArray(o, out);
                            continue;
                        }
                        out.append(o.toString());
                    }
                }
                out.append(") -> ");
                try {
                    Object r = method.invoke(instance, args);
                    if (r != null && r.getClass().isArray()) {
                        LoggingProxy.appendArray(r, out);
                    } else {
                        out.append(r.toString());
                    }
                    out.append(lineSeparator);
                    return r;
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
        });
    }

    private static void appendArray(Object ar, Appendable b) throws IOException {
        if (ar.getClass().getComponentType().isPrimitive()) {
            b.append(ar.toString());
        } else {
            b.append(Arrays.toString((Object[])ar));
        }
    }

    static {
        String ls = System.getProperty("line.separator");
        if (ls == null) {
            ls = "\n";
        }
        lineSeparator = ls;
    }
}

