/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.runner;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import jp.go.nict.langrid.commons.runner.MultithreadRunner;
import jp.go.nict.langrid.commons.runner.RunException;
import jp.go.nict.langrid.commons.runner.SinglethreadRunnable;
import jp.go.nict.langrid.commons.runner.StatusReporter;

public class RepeatingMultithreadRunner
extends MultithreadRunner {
    private int repeatCount;

    public RepeatingMultithreadRunner(int threadCount, int repeatCount, int retryCount, StatusReporter reporter) {
        super(threadCount, retryCount, reporter);
        this.repeatCount = repeatCount;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    @Override
    protected int getTotalCount() {
        return this.repeatCount * this.getThreadCount();
    }

    @Override
    protected Runnable createRunnable(String name, SinglethreadRunnable runnable, CountDownLatch startSignal, CountDownLatch endSignal, List<Exception> exceptions) {
        return new RunnableRunnable(name, this.repeatCount, runnable, startSignal, endSignal, exceptions);
    }

    private class RunnableRunnable
    implements Runnable {
        private String name;
        private int repeatCount;
        private SinglethreadRunnable runnable;
        private CountDownLatch startSignal;
        private CountDownLatch endSignal;
        private List<Exception> exceptions;

        public RunnableRunnable(String name, int repeatCount, SinglethreadRunnable runnable, CountDownLatch startSignal, CountDownLatch endSignal, List<Exception> exceptions) {
            this.name = name;
            this.repeatCount = repeatCount;
            this.runnable = runnable;
            this.startSignal = startSignal;
            this.endSignal = endSignal;
            this.exceptions = exceptions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.startSignal.await();
                for (int i = 0; i < this.repeatCount; ++i) {
                    int c = 0;
                    long s = System.currentTimeMillis();
                    while (true) {
                        try {
                            this.runnable.run();
                            RepeatingMultithreadRunner.this.done(System.currentTimeMillis() - s);
                        }
                        catch (Exception e) {
                            this.exceptions.add(new RunException("exception in " + this.name + " at " + (c + 1) + " try", e));
                            if (c < RepeatingMultithreadRunner.this.getRetryCount()) {
                                ++c;
                                Thread.sleep(Math.round(Math.random() * (double)RepeatingMultithreadRunner.this.getRetryWaitRangeMillis() + (double)RepeatingMultithreadRunner.this.getRetryWaitMinMillis()));
                                continue;
                            }
                            RepeatingMultithreadRunner.this.fault(System.currentTimeMillis() - s, e);
                        }
                        break;
                    }
                }
            }
            catch (InterruptedException e) {
                RepeatingMultithreadRunner.this.fault(0L);
            }
            finally {
                this.endSignal.countDown();
            }
        }
    }
}

