/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import jp.go.nict.langrid.commons.transformer.ToStringTransformer;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.transformer.TransformerUtil;
import jp.go.nict.langrid.commons.util.ArrayUtil;

public class ObjectToEnumTransformer<T extends Enum<T>>
implements Transformer<Object, T> {
    private Class<T> clazz;
    private T[] constants;
    private Method valueOf;

    public ObjectToEnumTransformer(Class<T> clazz) {
        this.clazz = clazz;
        this.constants = (Enum[])clazz.getEnumConstants();
        try {
            this.valueOf = clazz.getDeclaredMethod("valueOf", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public T transform(Object value) throws TransformationException {
        try {
            int i;
            if (value instanceof Number && this.constants != null && (i = ((Number)value).intValue()) < this.constants.length) {
                return this.constants[i];
            }
            return (T)((Enum)TransformerUtil.convertWithStaticMethod(this.valueOf, value.toString(), this.clazz));
        }
        catch (TransformationException e) {
            Throwable t;
            if (e.getCause() instanceof InvocationTargetException && (t = ((InvocationTargetException)e.getCause()).getCause()) instanceof IllegalArgumentException) {
                try {
                    throw new TransformationException("\"" + value + "\" is not valid and must be one of " + Arrays.toString(this.getCandidates(this.clazz)));
                }
                catch (IllegalAccessException ex) {
                    throw e;
                }
                catch (InvocationTargetException ex) {
                    throw e;
                }
                catch (NoSuchMethodException ex) {
                    throw e;
                }
            }
            throw e;
        }
    }

    private String[] getCandidates(Class<T> c) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Object[] candidates = (Object[])c.getMethod("values", new Class[0]).invoke(null, new Object[0]);
        return (String[])ArrayUtil.collect(candidates, new ToStringTransformer());
    }
}

