/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class StringToClassTransformer<T>
implements Transformer<String, Class<T>> {
    private boolean ignoreException;

    public StringToClassTransformer() {
    }

    public StringToClassTransformer(boolean ignoreException) {
        this.ignoreException = ignoreException;
    }

    @Override
    public Class<T> transform(String value) throws TransformationException {
        try {
            return Class.forName(value);
        }
        catch (ClassNotFoundException e) {
            if (this.ignoreException) {
                return null;
            }
            throw new TransformationException(e);
        }
    }
}

