/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import jp.go.nict.langrid.commons.util.Pair;

public class SOAPBodyUtil {
    private static final Pattern faultCodePattern = Pattern.compile(".*\\<faultcode.*?\\>(.*?)\\<\\/faultcode\\>", 32);
    private static final Pattern faultStringPattern = Pattern.compile(".*\\<faultstring.*?\\>(.*?)\\<\\/faultstring\\>", 32);

    public static Pair<String, String> extractSoapFaultString(InputStream inputstream) throws IOException {
        Scanner s = new Scanner(inputstream, "UTF-8").useDelimiter("");
        String first = null;
        try {
            MatchResult r = s.skip(faultCodePattern).match();
            if (r.groupCount() > 0) {
                first = r.group(1);
            }
        }
        catch (IllegalStateException r) {
        }
        catch (NoSuchElementException r) {
            // empty catch block
        }
        String second = null;
        try {
            MatchResult r = s.skip(faultStringPattern).match();
            if (r.groupCount() > 0) {
                second = r.group(1);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return Pair.create(first, second);
    }
}

