/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.text.NumberFormat;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Formatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.StringFormatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.io.OutputSource;

final class FloatFormatter
implements Formatter {
    public static final FloatFormatter INSTANCE = new FloatFormatter();

    FloatFormatter() {
    }

    @Override
    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        NumberFormat f = context.getNumberFormat();
        if (f != null) {
            StringFormatter.serialize(context, f.format(o), out);
        } else {
            double d = ((Number)o).doubleValue();
            if (Double.isNaN(d) || Double.isInfinite(d)) {
                if (context.getMode() != JSON.Mode.SCRIPT) {
                    out.append('\"');
                    out.append(o.toString());
                    out.append('\"');
                } else if (Double.isNaN(d)) {
                    out.append("Number.NaN");
                } else {
                    out.append("Number.");
                    out.append(d > 0.0 ? "POSITIVE" : "NEGATIVE");
                    out.append("_INFINITY");
                }
            } else {
                out.append(o.toString());
            }
        }
        return false;
    }
}

