/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.List;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.Formatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSON;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.JSONHint;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.StringFormatter;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.io.OutputSource;
import jp.go.nict.langrid.repackaged.net.arnx.jsonic.util.PropertyInfo;

final class ObjectFormatter
implements Formatter {
    public static final ObjectFormatter INSTANCE = new ObjectFormatter();

    ObjectFormatter() {
    }

    @Override
    public boolean format(JSON json, JSON.Context context, Object src, Object o, OutputSource out) throws Exception {
        List<PropertyInfo> props = context.getGetProperties(o.getClass());
        out.append('{');
        int count = 0;
        int length = props.size();
        for (int p = 0; p < length; ++p) {
            PropertyInfo prop = props.get(p);
            Object value = null;
            Exception cause = null;
            try {
                value = prop.get(o);
                if (value == src || context.isSuppressNull() && value == null || context.isSuppressEmptyArray() && value != null && (value.getClass().isArray() && Array.getLength(value) == 0 || value instanceof Collection && ((Collection)value).size() == 0)) continue;
                if (count != 0) {
                    out.append(',');
                }
                if (context.isPrettyPrint()) {
                    out.append('\n');
                    for (int j = 0; j < context.getDepth() + 1; ++j) {
                        out.append('\t');
                    }
                }
            }
            catch (Exception e) {
                cause = e;
            }
            StringFormatter.serialize(context, prop.getName(), out);
            out.append(':');
            if (context.isPrettyPrint()) {
                out.append(' ');
            }
            context.enter(prop.getName(), prop.getReadAnnotation(JSONHint.class));
            if (cause != null) {
                throw cause;
            }
            value = json.preformatInternal(context, value);
            json.formatInternal(context, value, out);
            context.exit();
            ++count;
        }
        if (context.isPrettyPrint() && count > 0) {
            out.append('\n');
            for (int j = 0; j < context.getDepth(); ++j) {
                out.append('\t');
            }
        }
        out.append('}');
        return true;
    }
}

