/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.go.nict.langrid.commons.net.proxy.ProxyUtil;
import jp.go.nict.langrid.commons.net.proxy.SubnetUtil;

public class ChainProxySelector
extends ProxySelector {
    private ProxySelector[] selectors;
    private ProxySelector previousSelector;
    private boolean considerSubnetAdresses;
    private static Logger logger = Logger.getLogger(ChainProxySelector.class.getName());

    public ChainProxySelector(ProxySelector ... selectors) {
        this.considerSubnetAdresses = true;
        this.selectors = selectors;
    }

    public ChainProxySelector(boolean considerSubnetAdresses, ProxySelector ... selectors) {
        this.considerSubnetAdresses = considerSubnetAdresses;
        this.selectors = selectors;
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        if (this.previousSelector != null) {
            this.previousSelector.connectFailed(uri, sa, ioe);
        }
    }

    @Override
    public List<Proxy> select(URI uri) {
        if (uri == null || uri.getHost() == null || uri.getHost().equals("wpad") || uri.getHost().startsWith("wpad.")) {
            this.previousSelector = null;
            return ProxyUtil.DIRECT;
        }
        if (this.considerSubnetAdresses) {
            try {
                InetAddress host = InetAddress.getByName(uri.getHost());
                if (SubnetUtil.isInSubnet(host)) {
                    return ProxyUtil.DIRECT;
                }
            }
            catch (SocketException e) {
                logger.log(Level.WARNING, "socket exception", e);
            }
            catch (UnknownHostException e) {
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "socket exception", e);
            }
        }
        return this.doSelect(uri);
    }

    private List<Proxy> doSelect(URI uri) {
        for (ProxySelector s : this.selectors) {
            List<Proxy> proxies = s.select(uri);
            for (Proxy p : proxies) {
                if (p.equals(Proxy.NO_PROXY)) continue;
                this.previousSelector = s;
                return proxies;
            }
        }
        this.previousSelector = null;
        return ProxyUtil.DIRECT;
    }
}

