/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net.proxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;

public class SubnetUtil {
    public static boolean isInSubnet(InetAddress address) throws IOException, SocketException {
        InetAddress[] myAddresses;
        byte[] subnetMask = SubnetUtil.detectSubnetMask().getAddress();
        if (address.getAddress().length != subnetMask.length) {
            return false;
        }
        byte[] maskedAddr = SubnetUtil.mask(address.getAddress(), subnetMask);
        for (InetAddress a : myAddresses = SubnetUtil.getLocalAddresses()) {
            byte[] addr;
            if (a.getAddress().length != subnetMask.length || !Arrays.equals(addr = SubnetUtil.mask(a.getAddress(), subnetMask), maskedAddr)) continue;
            return true;
        }
        return false;
    }

    public static InetAddress detectSubnetMask() {
        block9: {
            try {
                String line;
                if (System.getProperty("os.name").indexOf("Windows") == -1) {
                    String line2;
                    Process process = Runtime.getRuntime().exec("/sbin/ifconfig");
                    InputStream is = process.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    while ((line2 = br.readLine()) != null) {
                        if (line2.indexOf("127.0.0.1") != -1) continue;
                        int i = line2.indexOf("netmask");
                        if (i != -1 && line2.indexOf("boradcast") != -1) {
                            InetAddress r = SubnetUtil.parseLinuxSubnetMask(line2);
                            if (r != null) {
                                return r;
                            }
                            break block9;
                        }
                        i = line2.indexOf("Mask:");
                        if (i == -1) continue;
                        String addr = line2.substring(i + 5);
                        return InetAddress.getByName(addr);
                    }
                    break block9;
                }
                Process process = Runtime.getRuntime().exec("ipconfig");
                InputStream is = process.getInputStream();
                BufferedReader br = new BufferedReader(new InputStreamReader(is, "Shift_JIS"));
                while ((line = br.readLine()) != null) {
                    if (line.indexOf("Subnet") == -1 && line.indexOf("\u30b5\u30d6\u30cd\u30c3\u30c8 \u30de\u30b9\u30af") == -1) continue;
                    return SubnetUtil.parseWindowsSubnetMask(line);
                }
            }
            catch (IOException process) {
                // empty catch block
            }
        }
        try {
            return InetAddress.getByName("255.255.255.0");
        }
        catch (UnknownHostException exp) {
            return null;
        }
    }

    private static InetAddress[] getLocalAddresses() throws SocketException {
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        ArrayList<InetAddress> ret = new ArrayList<InetAddress>();
        while (e.hasMoreElements()) {
            NetworkInterface i = e.nextElement();
            Enumeration<InetAddress> addresses = i.getInetAddresses();
            while (addresses.hasMoreElements()) {
                ret.add(addresses.nextElement());
            }
        }
        return ret.toArray(new InetAddress[0]);
    }

    private static byte[] mask(byte[] address, byte[] mask) {
        byte[] ret = new byte[address.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (byte)(address[i] & mask[i]);
        }
        return ret;
    }

    static InetAddress parseWindowsSubnetMask(String line) throws UnknownHostException {
        int beginIndex = line.indexOf(":") + 2;
        int endIndex = line.length();
        return InetAddress.getByName(line.substring(beginIndex, endIndex));
    }

    static InetAddress parseLinuxSubnetMask(String line) throws UnknownHostException {
        int e = line.indexOf("broadcast");
        if (e == -1) {
            return null;
        }
        String v = line.substring(line.indexOf("netmask") + 8, --e);
        if (v.startsWith("0x")) {
            try {
                long address = Long.parseLong(v.substring(2), 16);
                return InetAddress.getByAddress(new byte[]{(byte)(address >> 24), (byte)(address >> 16 & 0xFFL), (byte)(address >> 8 & 0xFFL), (byte)(address & 0xFFL)});
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            return InetAddress.getByName(v);
        }
        return null;
    }
}

