/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.ws.soap;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import jp.go.nict.langrid.commons.rpc.RpcHeader;

public class SoapHeaderRpcHeadersAdapter
implements Collection<RpcHeader> {
    private SOAPHeader header;

    public SoapHeaderRpcHeadersAdapter(SOAPHeader header) {
        this.header = header;
    }

    @Override
    public boolean add(RpcHeader e) {
        try {
            this.header.addChildElement(e.getName(), "ns", e.getNamespace()).setValue(e.getValue());
        }
        catch (SOAPException e1) {
            throw new RuntimeException(e1);
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends RpcHeader> c) {
        for (RpcHeader rpcHeader : c) {
            this.add(rpcHeader);
        }
        return true;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return this.header.equals(obj);
    }

    @Override
    public int hashCode() {
        return this.header.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.isEmpty();
    }

    @Override
    public Iterator<RpcHeader> iterator() {
        return new Iterator<RpcHeader>(){
            private Iterator<SOAPHeaderElement> hi;
            {
                this.hi = SoapHeaderRpcHeadersAdapter.this.header.examineAllHeaderElements();
            }

            @Override
            public boolean hasNext() {
                return this.hi.hasNext();
            }

            @Override
            public RpcHeader next() {
                SOAPHeaderElement se = this.hi.next();
                return new RpcHeader(se.getNamespaceURI(), se.getLocalName(), se.getValue());
            }

            @Override
            public void remove() {
                this.hi.remove();
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        return this.header.removeChild((org.w3c.dom.Node)((Node)o)) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.header.getChildNodes().getLength();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }
}

