/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.repackaged.net.arnx.jsonic;

import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

final class ClassUtil {
    static final WeakHashMap<ClassLoader, Map<String, Class<?>>> cache = new WeakHashMap();
    static boolean accessible = true;

    private ClassUtil() {
    }

    public static ClassLoader getContextClassLoader() {
        ClassLoader cl = null;
        if (accessible) {
            try {
                cl = Thread.currentThread().getContextClassLoader();
            }
            catch (SecurityException e) {
                accessible = false;
            }
        }
        return cl;
    }

    public static Class<?> findClass(String name) {
        return ClassUtil.findClass(name, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> findClass(String name, boolean useCache) {
        Class<?> target;
        ClassLoader cl = ClassUtil.getContextClassLoader();
        if (useCache) {
            LinkedHashMap map;
            AbstractMap abstractMap = cache;
            synchronized (abstractMap) {
                map = cache.get(cl);
                if (map == null) {
                    map = new LinkedHashMap<String, Class<?>>(16, 0.75f, true){

                        @Override
                        protected boolean removeEldestEntry(Map.Entry<String, Class<?>> eldest) {
                            return this.size() > 1024;
                        }
                    };
                    cache.put(cl, map);
                }
            }
            abstractMap = map;
            synchronized (abstractMap) {
                if (!map.containsKey(name)) {
                    Class<?> target2;
                    try {
                        target2 = cl != null ? cl.loadClass(name) : Class.forName(name);
                    }
                    catch (ClassNotFoundException e) {
                        target2 = null;
                    }
                    map.put(name, target2);
                }
            }
            return (Class)map.get(name);
        }
        try {
            target = cl != null ? cl.loadClass(name) : Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            target = null;
        }
        return target;
    }

    public static boolean equals(String name, Class<?> cls) {
        Class<?> target = ClassUtil.findClass(name);
        return target != null && target.equals(cls);
    }

    public static boolean isAssignableFrom(String name, Class<?> cls) {
        Class<?> target = ClassUtil.findClass(name);
        return target != null && target.isAssignableFrom(cls);
    }

    public static Class<?> getRawType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof ParameterizedType) {
            return (Class)((ParameterizedType)t).getRawType();
        }
        if (t instanceof GenericArrayType) {
            Class<?> cls = null;
            try {
                cls = Array.newInstance(ClassUtil.getRawType(((GenericArrayType)t).getGenericComponentType()), 0).getClass();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return cls;
        }
        if (t instanceof WildcardType) {
            Type[] types = ((WildcardType)t).getUpperBounds();
            return types.length > 0 ? ClassUtil.getRawType(types[0]) : Object.class;
        }
        return Object.class;
    }

    public static Type resolveTypeVariable(TypeVariable<?> type, ParameterizedType parent) {
        Class<?> rawType = ClassUtil.getRawType(parent);
        if (rawType.equals(type.getGenericDeclaration())) {
            String tvName = type.getName();
            TypeVariable<Class<?>>[] rtypes = rawType.getTypeParameters();
            Type[] atypes = parent.getActualTypeArguments();
            for (int i = 0; i < rtypes.length; ++i) {
                if (!tvName.equals(rtypes[i].getName())) continue;
                return atypes[i];
            }
        }
        return type.getBounds()[0];
    }

    public static String toUpperCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = true;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String toLowerCamel(String name) {
        StringBuilder sb = new StringBuilder(name.length());
        boolean toUpperCase = false;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (c == ' ' || c == '_' || c == '-') {
                toUpperCase = true;
                continue;
            }
            if (toUpperCase) {
                sb.append(Character.toUpperCase(c));
                toUpperCase = false;
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 1 && Character.isUpperCase(sb.charAt(0)) && Character.isLowerCase(sb.charAt(1))) {
            sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clear() {
        WeakHashMap<ClassLoader, Map<String, Class<?>>> weakHashMap = cache;
        synchronized (weakHashMap) {
            cache.clear();
        }
    }
}

