/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.beanutils.ToBeanTransformer;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.FilteredIterator;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.util.function.Supplier;

public class BeanToBeanTransformer<T, U>
extends ToBeanTransformer<T, U>
implements Transformer<T, U> {
    public BeanToBeanTransformer(Converter converter, Class<U> targetClass) {
        this(converter, targetClass, Collections.EMPTY_MAP);
    }

    protected BeanToBeanTransformer(Converter converter, Map<String, String> propertyAliases) {
        super(converter, propertyAliases);
    }

    public BeanToBeanTransformer(Converter converter, Class<U> targetClass, Map<String, String> propertyAliases) {
        super(converter, targetClass, propertyAliases);
    }

    @Override
    public U transform(final T value) throws TransformationException {
        if (value == null) {
            return null;
        }
        return this.doTransform(new Iterable<Pair<String, Supplier<Object>>>(){

            @Override
            public Iterator<Pair<String, Supplier<Object>>> iterator() {
                return new FilteredIterator<Pair<String, Method>, Pair<String, Supplier<Object>>>(ClassUtil.getReadableProperties(value.getClass()).iterator()){

                    @Override
                    public Pair<String, Supplier<Object>> next() {
                        final Pair next = (Pair)this.getOrig().next();
                        return new Pair<String, Supplier<Object>>((String)next.getFirst(), new Supplier<Object>(){

                            @Override
                            public Object get() {
                                try {
                                    return ((Method)next.getSecond()).invoke(value, new Object[0]);
                                }
                                catch (InvocationTargetException e) {
                                    throw new TransformationException(e);
                                }
                                catch (IllegalArgumentException e) {
                                    throw new TransformationException(e);
                                }
                                catch (IllegalAccessException e) {
                                    throw new TransformationException(e);
                                }
                            }
                        });
                    }
                };
            }
        });
    }
}

