/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.nict.langrid.commons.beanutils.ConversionException;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.util.Pair;

public class DynamicInvocationHandler<T>
implements InvocationHandler {
    private T target;
    private Converter converter;

    public DynamicInvocationHandler(T target, Converter converter) {
        this.target = target;
        this.converter = converter;
    }

    protected void preInvocation() {
    }

    protected void postInvocation() {
    }

    protected T getTarget() {
        return this.target;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        this.preInvocation();
        try {
            Pair<Method, Object[]> m = this.findMethod(this.target.getClass(), method, args);
            if (m == null) {
                throw new RuntimeException("no suitable stub method.");
            }
            Object obj = this.convert(m.getFirst().invoke(this.target, m.getSecond()), method.getReturnType());
            return obj;
        }
        catch (InvocationTargetException e) {
            throw this.convertExcpetion(e.getCause(), method.getExceptionTypes());
        }
        finally {
            this.postInvocation();
        }
    }

    private Throwable convertExcpetion(Throwable e, Class<?>[] types) {
        Class<?> clazz = e.getClass();
        String sn = clazz.getSimpleName();
        for (Class<?> t : types) {
            if (t.isAssignableFrom(clazz)) {
                return e;
            }
            if (!sn.equalsIgnoreCase(t.getSimpleName())) continue;
            return (Throwable)this.convert(e, t);
        }
        return e;
    }

    private Pair<Method, Object[]> findMethod(Class<?> targetClass, Method method, Object[] args) {
        for (Method m : this.target.getClass().getMethods()) {
            if (!m.getName().equals(method.getName())) continue;
            try {
                Object[] convertedArgs = this.convert(args, m.getParameterTypes());
                return Pair.create(m, convertedArgs);
            }
            catch (ConversionException e) {
                // empty catch block
            }
        }
        return null;
    }

    private Object[] convert(Object[] arguments, Class<?>[] convertTypes) throws ConversionException {
        if (arguments.length != convertTypes.length) {
            throw new ConversionException("length not match.");
        }
        Object[] convertedArgs = new Object[arguments.length];
        for (int i = 0; i < arguments.length; ++i) {
            convertedArgs[i] = this.converter.convert(arguments[i], convertTypes[i]);
        }
        return convertedArgs;
    }

    private <U> U convert(Object source, Class<U> targetClass) {
        if (source == null) {
            return null;
        }
        if (targetClass.isAssignableFrom(source.getClass())) {
            return targetClass.cast(source);
        }
        return this.converter.convert(source, targetClass);
    }
}

