/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.beanutils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import jp.go.nict.langrid.commons.beanutils.ConversionException;
import jp.go.nict.langrid.commons.beanutils.Converter;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.util.function.Supplier;

public abstract class ToBeanTransformer<T, U>
implements Transformer<T, U> {
    private Converter converter;
    private Class<U> targetClass;
    private Map<String, String> aliases;

    public ToBeanTransformer(Converter converter, Class<U> targetClass) {
        this(converter, targetClass, Collections.EMPTY_MAP);
    }

    protected ToBeanTransformer(Converter converter, Map<String, String> propertyAliases) {
        Class<?>[] types = GenericsUtil.getTypeArgumentClasses(this.getClass(), Transformer.class);
        this.converter = converter;
        this.targetClass = types[1];
        this.aliases = propertyAliases;
    }

    public ToBeanTransformer(Converter converter, Class<U> targetClass, Map<String, String> propertyAliases) {
        this.converter = converter;
        this.targetClass = targetClass;
        this.aliases = propertyAliases;
    }

    protected U doTransform(Iterable<Pair<String, Supplier<Object>>> properties) throws TransformationException {
        try {
            U target = this.targetClass.newInstance();
            for (Pair<String, Supplier<Object>> prop : properties) {
                Object src;
                Method setter;
                String name = prop.getFirst();
                if (this.aliases.containsKey(name)) {
                    name = this.aliases.get(name);
                }
                if ((setter = ClassUtil.findSetter(this.targetClass, name)) == null || (src = prop.getSecond().get()) == null) continue;
                Class<?> setterParamClass = setter.getParameterTypes()[0];
                if (!ClassUtil.isAssignableFrom(setterParamClass, src.getClass())) {
                    src = this.converter.convert(src, setterParamClass);
                }
                setter.invoke(target, src);
            }
            return target;
        }
        catch (IllegalAccessException e) {
            throw new ConversionException(e);
        }
        catch (InstantiationException e) {
            throw new ConversionException(e);
        }
        catch (IllegalArgumentException e) {
            throw new ConversionException(e);
        }
        catch (InvocationTargetException e) {
            throw new ConversionException(e);
        }
    }
}

