/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ByteDetectingInputStream
extends FilterInputStream {
    private int detectByte;
    private int position;
    private List<Integer> positions = new ArrayList<Integer>();

    public ByteDetectingInputStream(InputStream in, int detectByte) {
        super(in);
        this.detectByte = detectByte;
    }

    public Integer[] getDetectedPositions() {
        return this.positions.toArray(new Integer[0]);
    }

    public void clearPositions() {
        this.positions.clear();
        this.position = 0;
    }

    @Override
    public int read() throws IOException {
        int r = this.in.read();
        if (r != -1) {
            if (r == this.detectByte) {
                this.positions.add(this.position);
            }
            ++this.position;
        }
        return r;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int r = this.in.read(b);
        if (r != -1) {
            for (int i = 0; i < r; ++i) {
                if (b[i] == this.detectByte) {
                    this.positions.add(this.position);
                }
                ++this.position;
            }
        }
        return r;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int r = this.in.read(b, off, len);
        if (r != -1) {
            for (int i = 0; i < r; ++i) {
                if (b[i + off] == this.detectByte) {
                    this.positions.add(this.position);
                }
                ++this.position;
            }
        }
        return r;
    }
}

