/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import jp.go.nict.langrid.commons.io.CloseableIterator;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.lang.StringUtil;
import jp.go.nict.langrid.commons.lang.block.BlockPE;

public final class FileUtil {
    public static File createUniqueFile(File directory, String prefix) throws IOException {
        return FileUtil.createUniqueFile(directory, prefix, "");
    }

    public static File createUniqueFile(File directory, String prefix, String suffix) throws IOException {
        if (!directory.exists()) {
            throw new IOException("Directory " + directory + " not exists.");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory.");
        }
        for (int i = 0; i < 10000; ++i) {
            String name = prefix + StringUtil.randomString(8) + suffix;
            File file = new File(directory, name);
            if (!file.createNewFile()) continue;
            return file;
        }
        throw new IOException("failed to create unique entity.");
    }

    public static File createUniqueDirectory(File directory, String prefix) throws IOException {
        if (!directory.exists()) {
            throw new IOException("Directory " + directory + " not exists.");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory.");
        }
        for (int i = 0; i < 10000; ++i) {
            String name = prefix + StringUtil.randomString(8);
            File file = new File(directory, name);
            if (!file.mkdir()) continue;
            return file;
        }
        throw new IOException("failed to create unique entity.");
    }

    public static boolean assertDirectoryExists(File directory) {
        if (!directory.exists()) {
            return directory.mkdirs();
        }
        return directory.isDirectory();
    }

    public static boolean forceDelete(File path) {
        if (!path.exists()) {
            return true;
        }
        if (path.isDirectory()) {
            for (File file : path.listFiles()) {
                if (file.toString().equals(".") || file.toString().equals("..")) continue;
                boolean success = false;
                if (file.isDirectory()) {
                    success = FileUtil.forceDelete(file);
                    if (success) {
                        success = file.delete();
                    }
                } else {
                    success = file.delete();
                }
                if (success) continue;
                return false;
            }
        }
        return path.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readAsString(File file, String encodingName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            String string = StreamUtil.readAsString((InputStream)is, encodingName);
            return string;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> readLines(File file, String encodingName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            Collection<String> collection = StreamUtil.readLines((InputStream)is, encodingName);
            return collection;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static CloseableIterator<String> iterateLines(File file, String encodingName) throws FileNotFoundException, IOException {
        final FileInputStream is = new FileInputStream(file);
        try {
            final InputStreamReader isr = new InputStreamReader((InputStream)is, encodingName);
            final BufferedReader br = new BufferedReader(isr);
            final boolean readyFirst = br.ready();
            return new CloseableIterator<String>(){
                private boolean ready;
                {
                    this.ready = readyFirst;
                }

                @Override
                public boolean hasNext() {
                    return this.ready;
                }

                @Override
                public String next() {
                    try {
                        String r = br.readLine();
                        this.ready = br.ready();
                        return r;
                    }
                    catch (IOException e) {
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void close() throws IOException {
                    br.close();
                    isr.close();
                    is.close();
                }
            };
        }
        catch (IOException e) {
            ((InputStream)is).close();
            throw e;
        }
    }

    public static String getHead(File file, String encodingName, int maxLines) throws FileNotFoundException, IOException {
        int n = 0;
        StringBuilder b = new StringBuilder();
        for (String s : FileUtil.readLines(file, encodingName)) {
            b.append(s).append("\n");
            if (++n < maxLines) continue;
            break;
        }
        return b.toString();
    }

    public static String getTail(File file, String encodingName, int maxLines) throws FileNotFoundException, IOException {
        ArrayList<String> ret = new ArrayList<String>();
        for (String s : FileUtil.readLines(file, encodingName)) {
            ret.add(s);
            if (ret.size() < maxLines) continue;
            ret.remove(0);
        }
        StringBuilder b = new StringBuilder();
        for (String s : ret) {
            b.append(s).append("\n");
        }
        return b.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string, String encodingName) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            StreamUtil.writeString((OutputStream)os, string, encodingName);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeString(File file, String string, String encodingName, boolean append) throws IOException {
        FileOutputStream os = new FileOutputStream(file, append);
        try {
            StreamUtil.writeString((OutputStream)os, string, encodingName);
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static void appendContent(File file, String string, String encodingName) throws IOException {
        FileUtil.writeString(file, string, encodingName, true);
    }

    public static void replaceContent(File file, String string, String encodingName) throws IOException {
        FileUtil.writeString(file, string, encodingName, false);
    }

    public static void writeStream(File file, InputStream is) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            StreamUtil.transfer(is, os);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withPrintWriter(File file, String encoding, BlockPE<PrintWriter, IOException> block) throws FileNotFoundException, UnsupportedEncodingException, IOException {
        FileOutputStream os = new FileOutputStream(file);
        try {
            StreamUtil.withPrintWriter(os, encoding, block);
            os.flush();
        }
        finally {
            ((OutputStream)os).close();
        }
    }
}

