/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.CharsetDecoder;
import java.util.logging.Logger;

public abstract class PropertyFileParser {
    private CharsetDecoder decoder;
    private static Logger logger = Logger.getLogger(PropertyFileParser.class.getName());

    public PropertyFileParser(CharsetDecoder aDecoder) {
        this.decoder = aDecoder;
    }

    protected void parse(InputStream inputStream, Listener listener) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, this.decoder));
        String line = null;
        int linenum = -1;
        while ((line = reader.readLine()) != null) {
            ++linenum;
            if (line.charAt(0) == '#') continue;
            int i = line.indexOf(61);
            if (i == -1) {
                logger.warning(String.format("illegal profile line #%d: \"%s\"", linenum, line));
                continue;
            }
            String name = line.substring(0, i).trim();
            String value = line.substring(i + 1).trim();
            listener.propertyFound(name, value);
        }
    }

    protected static interface Listener {
        public void propertyFound(String var1, String var2);
    }
}

