/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import jp.go.nict.langrid.commons.lang.ObjectUtil;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.util.function.Optional;

public class ClassUtil {
    private static Map<String, Class<?>> nameToPrimitiveClass = new HashMap();
    private static Map<String, Class<?>> primitiveToWrapperClass = new HashMap();
    private static Map<Class<?>, String> primitiveToArrayLiteral = new HashMap();
    private static Map<Class<?>, Class<?>> wrapperToPrimitive = new HashMap();
    private static Map<Class<?>, Object> primitiveToDefault = new HashMap();
    private static Map<Class<?>, Callable<Object>> p2r = new HashMap();
    private static Random random = new Random();

    public static Object newInstance(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz.isPrimitive()) {
            return primitiveToDefault.get(clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return Calendar.getInstance();
        }
        if (clazz.isArray()) {
            Class<?> ct = clazz.getComponentType();
            Object a = Array.newInstance(ct, 1);
            Array.set(a, 0, ClassUtil.newInstance(ct));
            return a;
        }
        return clazz.newInstance();
    }

    public static Object newDummyInstance(Class<?> clazz) throws InstantiationException, IllegalAccessException {
        if (clazz.isPrimitive()) {
            return primitiveToDefault.get(clazz);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            return Calendar.getInstance();
        }
        if (clazz.isArray()) {
            Class<?> ct = clazz.getComponentType();
            Object a = Array.newInstance(ct, 1);
            Array.set(a, 0, ClassUtil.newDummyInstance(ct));
            return a;
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (clazz.isAssignableFrom(HashMap.class)) {
            return new HashMap();
        }
        Object ret = clazz.newInstance();
        ObjectUtil.padProperties(ret);
        return ret;
    }

    public static Collection<Pair<String, Method>> getReadableProperties(Class<?> clazz) {
        ArrayList<Pair<String, Method>> ret = new ArrayList<Pair<String, Method>>();
        for (Method m : clazz.getMethods()) {
            if (m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 0) continue;
            String name = m.getName();
            if (name.startsWith("get")) {
                if (name.length() == 3 || m.getDeclaringClass().equals(Object.class)) continue;
                ret.add(Pair.create(name.substring(3, 4).toLowerCase() + (name.length() > 4 ? name.substring(4) : ""), m));
                continue;
            }
            if (!name.startsWith("is") || name.length() == 2 || m.getDeclaringClass().equals(Object.class) || !m.getReturnType().equals(Boolean.TYPE)) continue;
            ret.add(Pair.create(name.substring(2, 3).toLowerCase() + (name.length() > 3 ? name.substring(3) : ""), m));
        }
        return ret;
    }

    public static Method findGetter(Class<?> clazz, String name) throws SecurityException, NoSuchMethodException {
        String getterName = "get" + name.substring(0).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
        Method m = clazz.getMethod(getterName, new Class[0]);
        if (m != null) {
            if (!m.getReturnType().equals(Void.TYPE)) {
                return m;
            }
            return null;
        }
        getterName = "is" + name.substring(0).toUpperCase() + (name.length() > 1 ? name.substring(1) : "");
        m = clazz.getMethod(getterName, new Class[0]);
        if (m != null) {
            if (m.getReturnType().equals(Boolean.TYPE)) {
                return m;
            }
            return null;
        }
        return null;
    }

    public static Method findSetter(Method getter) {
        String n = getter.getName();
        if (!n.startsWith("get")) {
            return null;
        }
        if (n.length() <= 3) {
            return null;
        }
        try {
            return getter.getDeclaringClass().getMethod("set" + n.substring(3), getter.getReturnType());
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (SecurityException e) {
            return null;
        }
    }

    public static Method findSetter(Class<?> clazz, String property) {
        String setterName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        for (Method m : clazz.getMethods()) {
            if (!m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 1 || !m.getName().equals(setterName)) continue;
            return m;
        }
        return null;
    }

    public static Iterable<Method> findSetters(Class<?> clazz, String property) {
        ArrayList<Method> ret = new ArrayList<Method>();
        String setterName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(setterName) || !m.getReturnType().equals(Void.TYPE) || m.getParameterTypes().length != 1) continue;
            ret.add(m);
        }
        return ret;
    }

    public static Method findMethod(Class<?> clazz, String methodName) {
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }

    public static Method findMethod(Class<?> clazz, String methodName, int paramCount) {
        for (Method m : clazz.getMethods()) {
            Class<?>[] t;
            if (!m.getName().equals(methodName) || (t = m.getParameterTypes()).length != paramCount) continue;
            return m;
        }
        return null;
    }

    public static Object getDefaultValueForPrimitive(Class<?> type) {
        return primitiveToDefault.get(type);
    }

    public static Object getRandomValueForPrimitive(Class<?> type) {
        Callable<Object> c = p2r.get(type);
        if (c == null) {
            return null;
        }
        try {
            return c.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> forName(String name) throws ClassNotFoundException {
        Class<?> p = nameToPrimitiveClass.get(name);
        if (p != null) {
            return p;
        }
        return Class.forName(name);
    }

    public static Class<?> forName(String name, boolean initialize, ClassLoader loader) throws ClassNotFoundException {
        Class<?> p = nameToPrimitiveClass.get(name);
        if (p != null) {
            return p;
        }
        return Class.forName(name, initialize, loader);
    }

    public static boolean isPrimitive(String className) {
        return nameToPrimitiveClass.containsKey(className);
    }

    public static boolean isAssignableFrom(Class<?> class1, Class<?> class2) {
        if (class1.isAssignableFrom(class2)) {
            return true;
        }
        if (!class1.isPrimitive()) {
            return false;
        }
        Class<?> wrapper = primitiveToWrapperClass.get(class1.getName());
        return wrapper.isAssignableFrom(class2);
    }

    public static Class<?> getPrimitiveClass(String primitiveName) {
        return nameToPrimitiveClass.get(primitiveName);
    }

    public static Class<?> getPrimitiveClass(Class<?> wrapperClass) {
        return wrapperToPrimitive.get(wrapperClass);
    }

    public static Class<?> getWrapperClass(String primitiveName) {
        return primitiveToWrapperClass.get(primitiveName);
    }

    public static Class<?> getArrayClass(Class<?> clazz) {
        StringBuilder name = new StringBuilder("[");
        if (clazz.isPrimitive()) {
            String literal = primitiveToArrayLiteral.get(clazz);
            if (literal == null) {
                throw new IllegalArgumentException("unknown primitive type: " + clazz.toString());
            }
            name.append(literal);
        } else {
            name.append("L");
            name.append(clazz.getName());
            name.append(";");
        }
        try {
            return Class.forName(name.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar getLastModified(Class<?> clazz) {
        Calendar c;
        URL url;
        block11: {
            String fileString;
            int jarEntrySepIndex;
            String classResourceName = "/" + clazz.getName().replace(".", "/") + ".class";
            url = clazz.getResource(classResourceName);
            if (url == null) {
                return null;
            }
            c = Calendar.getInstance();
            if (url.toString().startsWith("jar:file:") && (jarEntrySepIndex = (fileString = url.toString().substring("jar:".length())).indexOf("!/")) != -1 && jarEntrySepIndex < fileString.length() + 2) {
                String entryName = fileString.substring(jarEntrySepIndex + 2);
                String jarName = fileString.substring("file:".length(), jarEntrySepIndex);
                try {
                    jarName = URLDecoder.decode(jarName, Charset.defaultCharset().name());
                    JarFile jf = new JarFile(jarName);
                    try {
                        ZipEntry e = jf.getEntry(entryName);
                        if (e == null) break block11;
                        c.setTimeInMillis(e.getTime());
                    }
                    finally {
                        jf.close();
                    }
                    return c;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            c.setTimeInMillis(url.openConnection().getLastModified());
            return c;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Optional<InputStream> getResourceAsStream(Class<?> clazz, String name) {
        return Optional.ofNullable(clazz.getResourceAsStream(name));
    }

    static {
        nameToPrimitiveClass.put("byte", Byte.TYPE);
        nameToPrimitiveClass.put("char", Character.TYPE);
        nameToPrimitiveClass.put("double", Double.TYPE);
        nameToPrimitiveClass.put("float", Float.TYPE);
        nameToPrimitiveClass.put("int", Integer.TYPE);
        nameToPrimitiveClass.put("long", Long.TYPE);
        nameToPrimitiveClass.put("short", Short.TYPE);
        nameToPrimitiveClass.put("boolean", Boolean.TYPE);
        nameToPrimitiveClass.put("void", Void.TYPE);
        wrapperToPrimitive.put(Boolean.class, Boolean.TYPE);
        wrapperToPrimitive.put(Byte.class, Byte.TYPE);
        wrapperToPrimitive.put(Character.class, Character.TYPE);
        wrapperToPrimitive.put(Double.class, Double.TYPE);
        wrapperToPrimitive.put(Float.class, Float.TYPE);
        wrapperToPrimitive.put(Integer.class, Integer.TYPE);
        wrapperToPrimitive.put(Long.class, Long.TYPE);
        wrapperToPrimitive.put(Short.class, Short.TYPE);
        wrapperToPrimitive.put(Void.class, Void.TYPE);
        primitiveToWrapperClass.put("byte", Byte.class);
        primitiveToWrapperClass.put("char", Character.class);
        primitiveToWrapperClass.put("double", Double.class);
        primitiveToWrapperClass.put("float", Float.class);
        primitiveToWrapperClass.put("int", Integer.class);
        primitiveToWrapperClass.put("long", Long.class);
        primitiveToWrapperClass.put("short", Short.class);
        primitiveToWrapperClass.put("boolean", Boolean.class);
        primitiveToWrapperClass.put("void", Void.class);
        primitiveToArrayLiteral.put(Boolean.TYPE, "Z");
        primitiveToArrayLiteral.put(Byte.TYPE, "B");
        primitiveToArrayLiteral.put(Character.TYPE, "C");
        primitiveToArrayLiteral.put(Short.TYPE, "S");
        primitiveToArrayLiteral.put(Integer.TYPE, "I");
        primitiveToArrayLiteral.put(Float.TYPE, "F");
        primitiveToArrayLiteral.put(Double.TYPE, "D");
        primitiveToArrayLiteral.put(Long.TYPE, "J");
        primitiveToDefault.put(Boolean.TYPE, false);
        primitiveToDefault.put(Byte.TYPE, (byte)0);
        primitiveToDefault.put(Character.TYPE, Character.valueOf('\u0000'));
        primitiveToDefault.put(Short.TYPE, (short)0);
        primitiveToDefault.put(Integer.TYPE, 0);
        primitiveToDefault.put(Long.TYPE, 0L);
        primitiveToDefault.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveToDefault.put(Double.TYPE, 0.0);
        primitiveToDefault.put(Void.TYPE, null);
        p2r.put(Boolean.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return random.nextBoolean();
            }
        });
        p2r.put(Character.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return Character.valueOf((char)(random.nextDouble() * 65536.0));
            }
        });
        p2r.put(Short.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return (short)(random.nextDouble() * 32768.0);
            }
        });
        p2r.put(Integer.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return random.nextInt();
            }
        });
        p2r.put(Long.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return random.nextLong();
            }
        });
        p2r.put(Float.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return Float.valueOf(random.nextFloat());
            }
        });
        p2r.put(Double.TYPE, new Callable<Object>(){

            @Override
            public Object call() {
                return random.nextDouble();
            }
        });
    }
}

