/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.lang.InvocationStream;
import jp.go.nict.langrid.commons.lang.reflect.MethodUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.ArrayUtil;

public class ObjectUtil {
    public static <T> T cast(Object object) {
        return (T)object;
    }

    public static <T> T getProperty(Object instance, String name) throws IllegalArgumentException, SecurityException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return (T)ClassUtil.findGetter(instance.getClass(), name).invoke(instance, new Object[0]);
    }

    public static void setProperty(Object instance, String name, Object value) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ClassUtil.findSetter(instance.getClass(), name).invoke(instance, value);
    }

    public static void padProperties(Object object) {
        ObjectUtil.padProperties(object, new HashSet(), 0);
    }

    private static void padProperties(Object object, Set<Class<?>> classes, int nest) {
        Class<?> c = object.getClass();
        if (classes.contains(c) && nest > 16) {
            return;
        }
        classes.add(c);
        for (Method m : c.getMethods()) {
            if (!MethodUtil.isGetter(m)) continue;
            Method s = ClassUtil.findSetter(m);
            if (s == null) {
                return;
            }
            try {
                s.invoke(object, ClassUtil.newDummyInstance(m.getReturnType()));
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static int getSize(Object ... objects) {
        int size = 0;
        for (Object o : objects) {
            size += o.toString().length();
        }
        return size;
    }

    public static Object invoke(Object instance, String methodName, Class<?>[] parameterTypes, Object[] parameters) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method m = instance.getClass().getMethod(methodName, parameterTypes);
        return m.invoke(instance, parameters);
    }

    public static Object invoke(Class<?> clazz, String methodName, Object ... parameters) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return ObjectUtil.doInvoke(clazz, null, methodName, parameters);
    }

    public static Object invoke(Object instance, String methodName, Object ... parameters) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        return ObjectUtil.doInvoke(instance.getClass(), instance, methodName, parameters);
    }

    public static InvocationStream invocationStream(Object value) {
        return new InvocationStream(value);
    }

    private static <T> Object doInvoke(Class<? extends T> clazz, T instance, String methodName, Object ... parameters) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class[] parameterTypes = ArrayUtil.collect(parameters, Class.class, new Transformer<Object, Class>(){

            @Override
            public Class<?> transform(Object value) throws TransformationException {
                return value.getClass();
            }
        });
        NoSuchMethodException nsme = null;
        try {
            return ObjectUtil.invokeSafely(instance, clazz.getMethod(methodName, parameterTypes), parameters);
        }
        catch (NoSuchMethodException e) {
            nsme = e;
            for (Method m : clazz.getMethods()) {
                Class<?>[] types;
                if (!m.getName().equals(methodName) || (types = m.getParameterTypes()).length != parameterTypes.length) continue;
                boolean matched = true;
                for (int i = 0; i < parameterTypes.length; ++i) {
                    if (ClassUtil.isAssignableFrom(types[i], parameterTypes[i])) continue;
                    matched = false;
                    break;
                }
                if (!matched) continue;
                return ObjectUtil.invokeSafely(instance, m, parameters);
            }
            throw nsme;
        }
    }

    public static Object invokeSafely(Object instance, Method method, Object ... args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        try {
            return method.invoke(instance, args);
        }
        catch (IllegalAccessException e) {
            if (instance != null) {
                String name = method.getName();
                Class<?>[] ptypes = method.getParameterTypes();
                for (Class<?> clazz = instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                    for (Class<?> i : clazz.getInterfaces()) {
                        try {
                            return i.getMethod(name, ptypes).invoke(instance, args);
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                        }
                    }
                }
            }
            throw e;
        }
    }
}

