/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.net.proxy.pac;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import jp.go.nict.langrid.commons.io.StreamUtil;
import jp.go.nict.langrid.commons.net.proxy.CachingProxySelector;
import jp.go.nict.langrid.commons.net.proxy.ChainProxySelector;
import jp.go.nict.langrid.commons.net.proxy.SocketProxySelector;
import jp.go.nict.langrid.commons.net.proxy.pac.ProxyFormatException;
import jp.go.nict.langrid.commons.net.proxy.pac.WPADProxySelector;

public class PacUtil {
    public static final String WPAD_SCRIPT_URL = "http://wpad/wpad.dat";
    static final Pattern proxySettingPattern;
    private static Map<String, Proxy.Type> proxyTypes;
    private static boolean disableWpad;

    public static void setupDefaultProxySelector() {
        ProxySelector.setDefault(PacUtil.getDefaultProxySelector());
    }

    public static ProxySelector getDefaultProxySelector() {
        WPADProxySelector wpad = new WPADProxySelector();
        ProxySelector def = ProxySelector.getDefault();
        SocketProxySelector socket = new SocketProxySelector(def);
        return new CachingProxySelector(disableWpad ? new ChainProxySelector(def, socket) : new ChainProxySelector(def, socket, wpad));
    }

    public static String findPacFromDNS() throws IOException {
        URL url = new URL(WPAD_SCRIPT_URL);
        return new String(StreamUtil.readAsBytes(url.openConnection(Proxy.NO_PROXY).getInputStream()), "UTF-8");
    }

    public static List<Proxy> toProxies(String result) throws ProxyFormatException {
        return PacUtil.toProxies(result, false);
    }

    public static List<Proxy> toProxies(String result, boolean resolveAddress) throws ProxyFormatException {
        ArrayList<Proxy> proxies = new ArrayList<Proxy>();
        Proxy.Type previousProxyType = null;
        Scanner s = new Scanner(result);
        while (s.hasNext()) {
            Proxy.Type proxyType;
            if (s.findInLine(proxySettingPattern) == null) {
                throw new ProxyFormatException(result);
            }
            MatchResult m = s.match();
            if (m.group(5) != null) {
                proxies.add(Proxy.NO_PROXY);
                continue;
            }
            String pt = m.group(1).toUpperCase();
            String host = m.group(2);
            int port = Integer.parseInt(m.group(4));
            if (pt.length() > 0) {
                previousProxyType = proxyType = proxyTypes.get(pt);
            } else {
                proxyType = previousProxyType;
            }
            InetSocketAddress addr = resolveAddress ? new InetSocketAddress(host, port) : InetSocketAddress.createUnresolved(host, port);
            proxies.add(new Proxy(proxyType, addr));
        }
        return proxies;
    }

    static {
        disableWpad = false;
        proxyTypes = new HashMap<String, Proxy.Type>();
        proxyTypes.put("DIRECT", Proxy.Type.DIRECT);
        proxyTypes.put("PROXY", Proxy.Type.HTTP);
        proxyTypes.put("SOCKS", Proxy.Type.SOCKS);
        proxySettingPattern = Pattern.compile("(PROXY|SOCKS|)\\s(\\w+(\\.\\w+)*):(\\d{1,5})|(DIRECT)", 2);
        try {
            String dw = System.getProperty("jp.go.nict.langrid.commons.net.proxy.pac.PacUtil.disableWpad");
            if (dw != null && dw.equals("true")) {
                disableWpad = true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

