/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.rpc.json;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.namespace.QName;
import jp.go.nict.langrid.commons.rpc.RpcHeader;
import jp.go.nict.langrid.commons.rpc.json.JsonRpcRequest;

public class JsonRpcUtil {
    private static AtomicInteger id = new AtomicInteger();

    public static JsonRpcRequest createRequest(Map<QName, Object> headers, Method method, Object ... args) {
        JsonRpcRequest req = new JsonRpcRequest();
        req.setId(Integer.toString(id.incrementAndGet()));
        ArrayList<RpcHeader> hs = new ArrayList<RpcHeader>();
        for (Map.Entry<QName, Object> h : headers.entrySet()) {
            hs.add(new RpcHeader(h.getKey().getNamespaceURI(), h.getKey().getLocalPart(), h.getValue().toString()));
        }
        req.setHeaders(hs.toArray(new RpcHeader[0]));
        req.setMethod(method.getName());
        req.setParams(args);
        return req;
    }

    public static JsonRpcRequest createRequest(Collection<RpcHeader> headers, Method method, Object ... args) {
        JsonRpcRequest req = new JsonRpcRequest();
        req.setId(Integer.toString(id.incrementAndGet()));
        req.setHeaders(headers.toArray(new RpcHeader[0]));
        req.setMethod(method.getName());
        req.setParams(args);
        return req;
    }
}

