/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.runner;

import java.io.PrintStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import jp.go.nict.langrid.commons.io.NullOutputStream;
import jp.go.nict.langrid.commons.runner.StatusReporter;

public class DefaultStatusReporter
implements StatusReporter {
    private long startMillis;
    private int current;
    private int exceptionCount;
    private List<Long> deltas = new LinkedList<Long>();
    private long dtSum;
    private PrintStream stream;
    private PrintStream exceptionStream;

    public DefaultStatusReporter(PrintStream stream) {
        this.stream = stream;
        this.exceptionStream = new PrintStream(new NullOutputStream());
    }

    public DefaultStatusReporter(PrintStream stream, PrintStream exceptionStream) {
        this.stream = stream;
        this.exceptionStream = exceptionStream;
    }

    @Override
    public void start() {
        this.startMillis = System.currentTimeMillis();
        this.current = 0;
    }

    @Override
    public synchronized void report(long dt, int doneCount, int faultCount, int total) {
        this.deltas.add(dt);
        this.dtSum += dt;
        int base = total / 100;
        ++this.current;
        if (base != 0 && this.current % base != 0) {
            return;
        }
        long d = System.currentTimeMillis() - this.startMillis;
        Runtime rt = Runtime.getRuntime();
        if (total == 0) {
            this.stream.println(String.format("100% done (success:%d fault:%d) in %d msec. avg:%dmsec.  heap:%dKB/%dKB", doneCount, faultCount, d, d, rt.totalMemory() / 1024L, rt.maxMemory() / 1024L));
        } else {
            this.stream.println(String.format("%d%% done (success:%d fault:%d) in %d msec. avg:%dmsec.  heap:%dKB/%dKB", (doneCount + faultCount) * 100 / total, doneCount, faultCount, d, d / (long)(doneCount + faultCount), rt.totalMemory() / 1024L, rt.maxMemory() / 1024L));
        }
    }

    @Override
    public synchronized void reportException(Exception exception) {
        this.exceptionStream.println("----- exception at " + this.current + "th call -----");
        exception.printStackTrace(this.exceptionStream);
        ++this.exceptionCount;
    }

    @Override
    public synchronized void end(int doneCount, int faultCount) {
        int i;
        this.stream.println("delta times:");
        for (long dt : this.deltas) {
            this.stream.println(dt);
        }
        int total = doneCount + faultCount;
        long d = System.currentTimeMillis() - this.startMillis;
        this.stream.println(d + "msec total. avg:" + d / (long)total + "msec.");
        this.stream.println(faultCount + " times fault.");
        Collections.sort(this.deltas);
        this.stream.println("fastest millis:");
        ListIterator<Long> it = this.deltas.listIterator();
        for (i = 0; i < 10 && it.hasNext(); ++i) {
            this.stream.println(" " + it.next() + "msec");
        }
        this.stream.println("latest millis:");
        it = this.deltas.listIterator(this.deltas.size());
        for (i = 0; i < 10 && it.hasPrevious(); ++i) {
            this.stream.println(" " + it.previous() + "msec");
        }
        this.stream.println("average millis: " + this.dtSum / (long)total + "msec");
        Runtime rt = Runtime.getRuntime();
        this.stream.printf("latest heap: %d/%d.", rt.totalMemory() / 1024L, rt.maxMemory() / 1024L);
        this.stream.println();
        System.gc();
        this.stream.printf("heap after gc: %d/%d.", rt.totalMemory() / 1024L, rt.maxMemory() / 1024L);
        this.stream.println();
        this.exceptionStream.println("total " + this.exceptionCount + " exceptions in " + this.current + " times call.");
    }
}

