/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;

public class BeanToStringPropertyTransformer<T>
implements Transformer<T, String> {
    private Method getter;

    public BeanToStringPropertyTransformer(Class<T> beanClass, String propName) throws NoSuchMethodException {
        this.getter = beanClass.getMethod("get" + propName.substring(0, 1).toUpperCase() + propName.substring(1), new Class[0]);
    }

    @Override
    public String transform(T value) throws TransformationException {
        try {
            return this.getter.invoke(value, new Object[0]).toString();
        }
        catch (IllegalAccessException e) {
            throw new TransformationException(e);
        }
        catch (InvocationTargetException e) {
            throw new TransformationException(e);
        }
    }
}

