/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.transformer;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.lang.reflect.TypeUtil;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.Pair;

public class Transformers {
    private Map<Pair<Class<?>, Class<?>>, Transformer<?, ?>> transformers = new HashMap();
    private Map<Class<?>, List<Pair<Class<?>, Transformer<?, ?>>>> dstToTransformer = new HashMap();

    public synchronized <T, U> void addTransformer(Class<T> src, Class<U> dst, Transformer<T, U> transformer) {
        this.transformers.put(new Pair<Class<T>, Class<U>>(src, dst), transformer);
        List<Pair<Class<?>, Transformer<?, ?>>> list = this.dstToTransformer.get(dst);
        if (list == null) {
            list = new ArrayList();
            this.dstToTransformer.put(dst, list);
        }
        list.add(new Pair<Class<T>, Transformer<T, U>>(src, transformer));
    }

    public synchronized <T, U> void addTransformer(Transformer<T, U> transformer) {
        Type[] types = GenericsUtil.getActualTypeArgumentTypes(transformer.getClass(), Transformer.class);
        Class<?> src = TypeUtil.toClass(types[0]);
        Class<?> dst = TypeUtil.toClass(types[1]);
        this.addTransformer(src, dst, transformer);
    }

    public synchronized <T, U> Transformer<T, U> get(Class<T> src, Class<U> dst) {
        Transformer<?, ?> transformer = this.transformers.get(Pair.create(src, dst));
        if (transformer != null) {
            return transformer;
        }
        List<Pair<Class<?>, Transformer<?, ?>>> list = this.dstToTransformer.get(dst);
        if (list != null) {
            for (Pair<Class<?>, Transformer<?, ?>> p : list) {
                if (!p.getFirst().isAssignableFrom(src)) continue;
                return p.getSecond();
            }
        }
        return null;
    }
}

