/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import jp.go.nict.langrid.commons.lang.ClassUtil;
import jp.go.nict.langrid.commons.lang.reflect.GenericsUtil;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.function.Predicate;
import jp.go.nict.langrid.commons.util.stream.IteratorProvider;
import jp.go.nict.langrid.commons.util.stream.Stream;

public class ArrayUtil {
    private static String[] emptyStrings_ = new String[0];
    private static Map<Class<?>, Transformer<Object, String>> primitiveArrayTransformers = new HashMap();

    public static <T> T[] array(T ... elements) {
        return elements;
    }

    public static <T> T[] array(Class<T> elementClass, Object ... elements) {
        Object ret = Array.newInstance(elementClass, elements.length);
        System.arraycopy(elements, 0, ret, 0, elements.length);
        return (Object[])ret;
    }

    public static Character[] box(char[] elements) {
        Character[] ret = new Character[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            ret[i] = Character.valueOf(elements[i]);
        }
        return ret;
    }

    public static <T> T first(T[] elements) {
        return elements[0];
    }

    public static <T> T last(T[] elements) {
        return elements[elements.length - 1];
    }

    public static <T> T getWithinBound(T[] elements, int index) {
        if (index < 0 || elements.length <= index) {
            return null;
        }
        return elements[index];
    }

    public static String toString(Object array) {
        Transformer<Object, String> transformer = primitiveArrayTransformers.get(array.getClass());
        if (transformer != null) {
            return transformer.transform(array);
        }
        if (Object[].class.isAssignableFrom(array.getClass())) {
            return Arrays.toString((Object[])array);
        }
        return array.toString();
    }

    public static <T> boolean elementsEqual(T[] src, T[] dst) {
        if (src.length != dst.length) {
            return false;
        }
        for (int i = 0; i < src.length; ++i) {
            if (src[i] != null) {
                if (src[i].equals(dst[i])) continue;
                return false;
            }
            if (dst[i] == null) continue;
            return false;
        }
        return true;
    }

    public static <T> T[] toArray(Iterable<T> elements, T[] a) {
        ArrayList<T> array = new ArrayList<T>();
        for (T e : elements) {
            array.add(e);
        }
        return array.toArray(a);
    }

    public static String[] emptyStrings() {
        return emptyStrings_;
    }

    public static <T> T[] clone(T[] elements) {
        if (elements != null) {
            return (Object[])elements.clone();
        }
        return null;
    }

    public static <T> T[] append(T[] elements, T element) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(elements));
        list.add(element);
        return list.toArray(elements);
    }

    public static <T> T[] append(T[] elements, T ... elements2) {
        ArrayList<T> list = new ArrayList<T>(Arrays.asList(elements));
        for (T e : elements2) {
            list.add(e);
        }
        return list.toArray(elements);
    }

    public static <T> T[] subArray(T[] elements, int beginIndex, int endIndex) {
        return Arrays.asList(elements).subList(beginIndex, endIndex).toArray((Object[])Array.newInstance(elements.getClass().getComponentType(), endIndex - beginIndex));
    }

    public static <T> T[] subArray(T[] elements, int beginIndex) {
        return ArrayUtil.subArray(elements, beginIndex, elements.length);
    }

    public static String join(String[] elements, String separator) {
        if (elements.length == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (String e : elements) {
            b.append(e);
            b.append(separator);
        }
        b.delete(b.length() - separator.length(), b.length());
        return b.toString();
    }

    public static String join(Object[] elements, String separator) {
        StringBuilder b = new StringBuilder();
        for (Object e : elements) {
            b.append(e.toString());
            b.append(separator);
        }
        b.delete(b.length() - separator.length(), b.length());
        return b.toString();
    }

    public static <T, U> U[] collect(T[] elements, Class<U> clazz, Transformer<T, U> transformer) throws TransformationException {
        Object[] r = (Object[])Array.newInstance(clazz, elements.length);
        for (int i = 0; i < elements.length; ++i) {
            r[i] = transformer.transform(elements[i]);
        }
        return r;
    }

    public static <T, U> U[] collect(T[] elements, Transformer<T, U> transformer) throws TransformationException {
        Class<?>[] types = GenericsUtil.getTypeArgumentClasses(transformer.getClass(), Transformer.class);
        if (types == null || types[1] == null) {
            throw new IllegalArgumentException("failed to resolve target class");
        }
        Object[] r = (Object[])Array.newInstance(types[1], elements.length);
        for (int i = 0; i < elements.length; ++i) {
            r[i] = transformer.transform(elements[i]);
        }
        return r;
    }

    public static <T> T[] filter(T[] elements, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T e : elements) {
            if (!pred.test(e)) continue;
            ret.add(e);
        }
        return ret.toArray((Object[])Array.newInstance(elements.getClass().getComponentType(), 0));
    }

    public static byte[][] toBytesArray(String[] value, String encoding) throws UnsupportedEncodingException {
        byte[][] ret = new byte[value.length][];
        for (int i = 0; i < value.length; ++i) {
            ret[i] = value[i].getBytes(encoding);
        }
        return ret;
    }

    public static String[] toStringArray(byte[][] value, String encoding) throws UnsupportedEncodingException {
        String[] ret = new String[value.length];
        for (int i = 0; i < value.length; ++i) {
            ret[i] = new String(value[i], encoding);
        }
        return ret;
    }

    public static <T> Object toPrimitiveArray(Collection<T> collection, Class<T> clazz) throws IllegalArgumentException {
        Class<?> p = ClassUtil.getPrimitiveClass(clazz);
        if (p == null) {
            throw new IllegalArgumentException(clazz.getName() + " is not a wrapper class");
        }
        int len = collection.size();
        Iterator<T> it = collection.iterator();
        Object ret = Array.newInstance(p, len);
        for (int i = 0; i < len; ++i) {
            Array.set(ret, i, it.next());
        }
        return ret;
    }

    public static <T> Stream<T> stream(T[] array) {
        return new Stream<T>(new IteratorProvider<T>(Arrays.asList(array).iterator()));
    }

    static {
        primitiveArrayTransformers.put(boolean[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((boolean[])value);
            }
        });
        primitiveArrayTransformers.put(byte[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((byte[])value);
            }
        });
        primitiveArrayTransformers.put(char[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((char[])value);
            }
        });
        primitiveArrayTransformers.put(double[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((double[])value);
            }
        });
        primitiveArrayTransformers.put(float[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((float[])value);
            }
        });
        primitiveArrayTransformers.put(int[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((int[])value);
            }
        });
        primitiveArrayTransformers.put(long[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((long[])value);
            }
        });
        primitiveArrayTransformers.put(short[].class, new Transformer<Object, String>(){

            @Override
            public String transform(Object value) throws TransformationException {
                return Arrays.toString((short[])value);
            }
        });
    }
}

