/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jp.go.nict.langrid.commons.transformer.TransformationException;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.Pair;
import jp.go.nict.langrid.commons.util.function.Predicate;
import jp.go.nict.langrid.commons.util.stream.IteratorProvider;
import jp.go.nict.langrid.commons.util.stream.Stream;

public class CollectionUtil {
    public static <T> boolean equalsAsSet(Collection<T> value1, Collection<T> value2) {
        HashSet<T> s1 = new HashSet<T>();
        for (T v : value1) {
            s1.add(v);
        }
        HashSet<T> s2 = new HashSet<T>();
        for (T v : value2) {
            s2.add(v);
        }
        return s1.equals(s2);
    }

    public static <T> boolean equalsAsSet(Collection<T> value1, Collection<T> value2, Class<T> clazz, String equalsMethodName) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method m = null;
        try {
            m = clazz.getMethod(equalsMethodName, clazz);
        }
        catch (NoSuchMethodException e) {
            m = clazz.getMethod(equalsMethodName, Object.class);
        }
        return CollectionUtil.equalsAsSet(value1, value2, m);
    }

    public static <T> boolean equalsAsSet(Collection<T> value1, Collection<T> value2, Method equalsMethod) throws IllegalAccessException, InvocationTargetException {
        if (!equalsMethod.getReturnType().equals(Boolean.TYPE)) {
            return false;
        }
        LinkedList<T> s1 = new LinkedList<T>();
        for (T v : value1) {
            s1.add(v);
        }
        for (T v : value2) {
            Iterator i2 = s1.iterator();
            boolean found = false;
            while (i2.hasNext()) {
                if (!((Boolean)equalsMethod.invoke(v, i2.next())).booleanValue()) continue;
                i2.remove();
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return s1.size() == 0;
    }

    public static <T, U> Map<T, U> asMap(Pair<T, U> ... elements) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (Pair<T, U> p : elements) {
            map.put(p.getFirst(), p.getSecond());
        }
        return map;
    }

    public static <T, U> Map<T, U> asMap(Map.Entry<T, U> ... elements) {
        HashMap<T, U> map = new HashMap<T, U>();
        for (Map.Entry<T, U> p : elements) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }

    public static <T, U> List<U> collect(Iterator<T> iterator, Transformer<T, U> transformer) throws TransformationException {
        ArrayList r = new ArrayList();
        CollectionUtil.collect(iterator, r, transformer);
        return r;
    }

    public static <T, U> List<U> collect(Iterable<T> elements, Transformer<T, U> transformer) throws TransformationException {
        ArrayList r = new ArrayList();
        CollectionUtil.collect(elements.iterator(), r, transformer);
        return r;
    }

    public static <T, U> void collect(Iterator<T> iterator, Collection<U> target, Transformer<T, U> transformer) throws TransformationException {
        while (iterator.hasNext()) {
            target.add(transformer.transform(iterator.next()));
        }
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> elementClass) {
        return CollectionUtil.toArray(collection, elementClass, 0, collection.size());
    }

    public static <T> T[] toArray(Collection<T> collection, Class<T> elementClass, int index, int count) {
        int n = collection.size();
        int end = Math.min(index + count, n);
        Object result = Array.newInstance(elementClass, end - index);
        Iterator<T> it = collection.iterator();
        int resultIndex = 0;
        for (int i = 0; i < end && it.hasNext(); ++i) {
            T value = it.next();
            if (i < index) continue;
            Array.set(result, resultIndex, value);
            ++resultIndex;
        }
        return (Object[])result;
    }

    public static <T> Collection<T> emptyCollection() {
        return Collections.EMPTY_LIST;
    }

    public static <T> Collection<T> filter(Iterable<T> collection, Predicate<T> pred) {
        ArrayList<T> ret = new ArrayList<T>();
        for (T v : collection) {
            if (!pred.test(v)) continue;
            ret.add(v);
        }
        return ret;
    }

    public static <T> Stream<T> stream(Iterable<T> collection) {
        return new Stream<T>(new IteratorProvider<T>(collection.iterator()));
    }
}

