/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util.function;

import java.util.NoSuchElementException;
import jp.go.nict.langrid.commons.util.function.Consumer;
import jp.go.nict.langrid.commons.util.function.Function;

public abstract class Optional<T> {
    private static final Empty empty = new Empty();

    public static <U> Optional<U> of(U value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new Present<U>(value);
    }

    public static <U> Optional<U> ofNullable(U value) {
        if (value != null) {
            return new Present<U>(value);
        }
        return new Empty();
    }

    public static final <U> Optional<U> empty() {
        return empty;
    }

    public abstract boolean isEmpty();

    public abstract void ifPresent(Consumer<T> var1);

    public abstract void ifEmpty(Runnable var1);

    public abstract void presentOrEmpty(Consumer<T> var1, Runnable var2);

    public abstract T get() throws NoSuchElementException;

    public abstract T orElse(T var1);

    public abstract <U> Optional<U> map(Function<T, U> var1);

    public static class Empty<U>
    extends Optional<U> {
        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void ifPresent(Consumer<U> consumer) {
        }

        @Override
        public void ifEmpty(Runnable consumer) {
            consumer.run();
        }

        @Override
        public void presentOrEmpty(Consumer<U> present, Runnable empty) {
            empty.run();
        }

        @Override
        public U get() {
            throw new NoSuchElementException();
        }

        @Override
        public U orElse(U elseValue) {
            return elseValue;
        }

        @Override
        public <V> Optional<V> map(Function<U, V> f) {
            return Empty.empty();
        }
    }

    public static class Present<U>
    extends Optional<U> {
        private U value;

        public Present(U value) {
            this.value = value;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void ifPresent(Consumer<U> consumer) {
            consumer.accept(this.value);
        }

        @Override
        public void ifEmpty(Runnable consumer) {
        }

        @Override
        public void presentOrEmpty(Consumer<U> present, Runnable empty) {
            present.accept(this.value);
        }

        @Override
        public U get() {
            return this.value;
        }

        @Override
        public U orElse(U elseValue) {
            return this.value;
        }

        @Override
        public <V> Optional<V> map(Function<U, V> f) {
            V v = f.apply(this.value);
            if (v != null) {
                return new Present<V>(v);
            }
            return Present.empty();
        }
    }
}

