/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.util.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jp.go.nict.langrid.commons.transformer.Transformer;
import jp.go.nict.langrid.commons.util.function.BiFunction;
import jp.go.nict.langrid.commons.util.function.Consumer;
import jp.go.nict.langrid.commons.util.function.Function;
import jp.go.nict.langrid.commons.util.function.Predicate;
import jp.go.nict.langrid.commons.util.stream.Provider;

public class Stream<T> {
    private Provider<T> provider;

    public Stream(Provider<T> provider) {
        this.provider = provider;
    }

    public <U> Stream<U> map(final Function<T, U> func) {
        this.assertProviderValid();
        return new Stream<T>(new Provider<U>(){
            Provider<T> p;
            {
                this.p = Stream.this.provider;
                Stream.this.provider = null;
            }

            @Override
            public U next() {
                Object v = this.p.next();
                if (v != null) {
                    return func.apply(v);
                }
                return null;
            }
        });
    }

    public <U> Stream<U> map(final Transformer<T, U> func) {
        this.assertProviderValid();
        return new Stream<T>(new Provider<U>(){
            Provider<T> p;
            {
                this.p = Stream.this.provider;
                Stream.this.provider = null;
            }

            @Override
            public U next() {
                Object v = this.p.next();
                if (v != null) {
                    return func.transform(v);
                }
                return null;
            }
        });
    }

    public T reduce(T identity, BiFunction<T, T, T> func) {
        this.assertProviderValid();
        T ret = identity;
        Object r = null;
        while (true) {
            T t = this.provider.next();
            r = t;
            if (t == null) break;
            ret = func.apply(ret, r);
        }
        return ret;
    }

    public Stream<T> filter(final Predicate<T> pred) {
        this.assertProviderValid();
        return new Stream<T>(new Provider<T>(){
            private Provider<T> p;
            {
                this.p = Stream.this.provider;
                Stream.this.provider = null;
            }

            @Override
            public T next() {
                block1: {
                    Object v = null;
                    do {
                        Object t = this.p.next();
                        v = t;
                        if (t == null) break block1;
                    } while (!pred.test(v));
                    return v;
                }
                return null;
            }
        });
    }

    public <U> Stream<U> expload(final Function<T, Provider<U>> func) {
        this.assertProviderValid();
        return new Stream<T>(new Provider<U>(){
            Provider<U> p;
            Provider<T> org;
            {
                this.org = Stream.this.provider;
                Stream.this.provider = null;
            }

            @Override
            public U next() {
                Object v;
                if (this.p == null) {
                    Object ov = this.org.next();
                    if (ov == null) {
                        return null;
                    }
                    this.p = (Provider)func.apply(ov);
                }
                if ((v = this.p.next()) != null) {
                    return v;
                }
                Object ov = this.org.next();
                if (ov == null) {
                    return null;
                }
                this.p = (Provider)func.apply(ov);
                return this.p.next();
            }
        });
    }

    public void forEach(Consumer<T> consumer) {
        this.assertProviderValid();
        Object v = null;
        while (true) {
            T t = this.provider.next();
            v = t;
            if (t == null) break;
            consumer.accept(v);
        }
    }

    public <C extends Collection<T>> C into(C collection) {
        this.assertProviderValid();
        Object v = null;
        while (true) {
            T t = this.provider.next();
            v = t;
            if (t == null) break;
            collection.add(v);
        }
        return collection;
    }

    public List<T> asList() {
        ArrayList ret = new ArrayList();
        this.into(ret);
        return ret;
    }

    private void assertProviderValid() {
        if (this.provider == null) {
            throw new IllegalStateException("This stream has been already consumed.");
        }
    }
}

