/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.codec;

import jp.go.nict.langrid.commons.codec.UnixFileNameCodec;
import jp.go.nict.langrid.commons.codec.WindowsFileNameCodec;
import jp.go.nict.langrid.commons.lang.PlatformUtil;

public abstract class FileNameCodec {
    private static final String digits = "0123456789";
    private static final String lhexalphas = "abcdef";
    private static final String uhexalphas = "ABCDEF";
    private static FileNameCodec instance;

    public abstract String encode(String var1);

    public abstract String decode(String var1);

    public static FileNameCodec getInstance() {
        return instance;
    }

    protected String decode(String value, char headerChar) {
        char[] chars = value.toCharArray();
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == headerChar) {
                i += this.decodeChars(chars, i, b, headerChar);
                --i;
                continue;
            }
            b.append(c);
        }
        return b.toString();
    }

    protected int decodeChars(char[] sequence, int start, StringBuilder buffer, char headerChar) {
        char c1 = sequence[start];
        char c2 = sequence[start + 1];
        char c3 = sequence[start + 2];
        if (c1 != headerChar) {
            buffer.append(c1);
            return 1;
        }
        if (!this.isHexAlphaOrDigit(c2)) {
            buffer.append(c1);
            return 1;
        }
        if (!this.isHexAlphaOrDigit(c3)) {
            buffer.append(sequence, start, 2);
            return 2;
        }
        try {
            buffer.append((char)Integer.parseInt(new String(sequence, start + 1, 2), 16));
        }
        catch (NumberFormatException e) {
            buffer.append(sequence, start, 3);
        }
        return 3;
    }

    protected boolean isHexAlphaOrDigit(char c) {
        int i = c - 48;
        if (0 < i && i < digits.length() && c == digits.charAt(i)) {
            return true;
        }
        i = c - 97;
        if (0 < i && i < lhexalphas.length() && c == lhexalphas.charAt(i)) {
            return true;
        }
        i = c - 65;
        return 0 < i && i < uhexalphas.length() && c == uhexalphas.charAt(i);
    }

    static {
        if (PlatformUtil.isMacOSX()) {
            instance = new UnixFileNameCodec();
        } else if (PlatformUtil.isLinux()) {
            instance = new UnixFileNameCodec();
        } else if (PlatformUtil.isWindows()) {
            instance = new WindowsFileNameCodec();
        }
    }
}

