/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.io;

import java.io.File;
import java.io.FileFilter;

public class FileFilters {
    public static FileFilter chain(final FileFilter ... filters) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (FileFilter f : filters) {
                    if (f.accept(file)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    public static FileFilter notEquals(final String name) {
        return new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return !pathname.getName().equals(name);
            }
        };
    }

    public static FileFilter endsWith(final String suffix) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(suffix);
            }
        };
    }

    public static FileFilter isFile() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        };
    }

    public static FileFilter isDirectory() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        };
    }

    public static FileFilter isFileEndsWith(String suffix) {
        return FileFilters.chain(FileFilters.isFile(), FileFilters.endsWith(suffix));
    }

    public static FileFilter isDirectoryEndsWith(String suffix) {
        return FileFilters.chain(FileFilters.isDirectory(), FileFilters.endsWith(suffix));
    }
}

