/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang;

import java.io.IOException;

public class ExceptionUtil {
    public static String getMessageWithStackTrace(Throwable e) {
        return ExceptionUtil.getMessageWithStackTrace(e, 3, 9);
    }

    public static String getMessageWithStackTrace(Throwable e, int maxStackDepth, int maxTotalStackDepth) {
        StringBuilder b = new StringBuilder();
        try {
            ExceptionUtil.appendMessage(e, b);
            b.append(". stack trace\"\"\"\n");
            ExceptionUtil.appendStackTrace(e, b, maxStackDepth, maxTotalStackDepth);
            b.append("\n\"\"\"");
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return b.toString();
    }

    public static void appendMessage(Throwable e, Appendable buff) throws IOException {
        buff.append(e.toString());
    }

    public static void appendStackTrace(Throwable e, Appendable buff, int maxStackDepth, int maxTotalStackDepth) throws IOException {
        boolean first = true;
        int stackCount = 0;
        while (e != null) {
            if (first) {
                first = false;
            } else {
                buff.append("Caused by: ");
                ExceptionUtil.appendMessage(e, buff);
                buff.append("\n");
            }
            StackTraceElement[] sts = e.getStackTrace();
            maxStackDepth = Math.min(maxStackDepth, sts.length);
            if (maxStackDepth > 0) {
                buff.append("\tat ");
                buff.append(sts[0].toString());
                buff.append("\n");
                for (int si = 1; si < maxStackDepth; ++si) {
                    if (stackCount >= maxTotalStackDepth) continue;
                    buff.append("\tat ");
                    buff.append(sts[si].toString());
                    buff.append("\n");
                    ++stackCount;
                }
                if (sts.length > maxStackDepth) {
                    buff.append("\t... ");
                    buff.append(Integer.toString(sts.length - maxStackDepth));
                    buff.append(" more");
                    buff.append("\n");
                }
            }
            if ((e = e.getCause()) != null) continue;
            break;
        }
    }
}

