/*
 * Decompiled with CFR 0.152.
 */
package jp.go.nict.langrid.commons.lang.reflect;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import jp.go.nict.langrid.commons.util.ArrayUtil;

public class GenericsUtil {
    public static Type[] getActualTypeArgumentTypes(Class<?> clazz, Class<?> parameterizedSuperOrInterface) {
        do {
            ParameterizedType pt;
            Type sp;
            if ((sp = clazz.getGenericSuperclass()) instanceof ParameterizedType && (pt = (ParameterizedType)sp).getRawType().equals(parameterizedSuperOrInterface)) {
                return pt.getActualTypeArguments();
            }
            for (Type intf : clazz.getGenericInterfaces()) {
                ParameterizedType pt2;
                if (!(intf instanceof ParameterizedType) || !(pt2 = (ParameterizedType)intf).getRawType().equals(parameterizedSuperOrInterface)) continue;
                return pt2.getActualTypeArguments();
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return null;
    }

    public static Class<?>[] getTypeArgumentClasses(Class<?> rootClass, Class<?> targetClass) {
        return GenericsUtil.doGetTypeArgumentClasses(rootClass, null, targetClass);
    }

    private static Class<?>[] doGetTypeArgumentClasses(Class<?> clazz, Class<?>[] typeArgs, Class<?> targetClass) {
        if (clazz == null) {
            return null;
        }
        if (clazz.equals(targetClass)) {
            return typeArgs;
        }
        HashMap params = new HashMap();
        TypeVariable<Class<?>>[] variables = clazz.getTypeParameters();
        if (typeArgs != null && typeArgs.length == variables.length) {
            for (int i = 0; i < variables.length; ++i) {
                params.put(variables[i], typeArgs[i]);
            }
        }
        for (Type superType : ArrayUtil.append(clazz.getGenericInterfaces(), clazz.getGenericSuperclass())) {
            Class superClass = null;
            Class[] argClasses = null;
            if (superType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)superType;
                Type[] argTypes = pt.getActualTypeArguments();
                argClasses = new Class[argTypes.length];
                for (int i = 0; i < argTypes.length; ++i) {
                    Type at = argTypes[i];
                    argClasses[i] = at instanceof Class ? (Class)at : (Class)params.get(at);
                }
                superClass = (Class)pt.getRawType();
            } else {
                superClass = (Class)superType;
            }
            Class<?>[] ret = GenericsUtil.doGetTypeArgumentClasses(superClass, argClasses, targetClass);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }
}

